% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxStrata.R
\name{coxStrata}
\alias{coxStrata}
\alias{coxStrata.cph}
\alias{coxStrata.coxph}
\alias{coxStrata.phreg}
\alias{coxStrata.prodlim}
\alias{coxStrata.GLMnet}
\title{Define the strata for a new dataset}
\usage{
coxStrata(object, data, sterms, strata.vars, strata.levels)

\method{coxStrata}{cph}(object, data, sterms, strata.vars, strata.levels)

\method{coxStrata}{coxph}(object, data, sterms, strata.vars, strata.levels)

\method{coxStrata}{phreg}(object, data, sterms, strata.vars, strata.levels)

\method{coxStrata}{prodlim}(object, data, sterms, strata.vars, strata.levels)

\method{coxStrata}{GLMnet}(object, data, sterms, strata.vars, strata.levels)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}

\item{data}{a \code{data.frame} or a \code{data.table}}

\item{sterms}{terms in the formula corresponding to the strata variables}

\item{strata.vars}{the name of the variables used to define the strata}

\item{strata.levels}{a named list containing for each variable used to form the strata all its possible levels}

\item{levels}{the strata levels that have been used to fit the Cox model}
}
\description{
Define the strata in a dataset to match those of a stratified Cox model
}
\details{
if no strata variables returns a vector of \code{"1"} (factor).
}
\author{
Brice Ozenne broz@sund.ku.dk
}
