% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer_series.R
\name{transfer_series}
\alias{transfer_series}
\title{Transfer_series}
\usage{
transfer_series(
  ws_from,
  ws_to,
  selected_series,
  pos_sap_from,
  pos_sap_to,
  name_sap_from,
  name_sap_to,
  verbose = TRUE,
  create_sap = TRUE,
  replace_series = TRUE
)
}
\arguments{
\item{ws_from}{The workspace containing the additionnal series}

\item{ws_to}{The workspace to add series to}

\item{selected_series}{The vector containing the series-to-update's names.}

\item{pos_sap_from}{The position of the SA-Processing to transfer the series
from}

\item{pos_sap_to}{The position of the SA-Processing to transfer the series to}

\item{name_sap_from}{The name of the SA-Processing to transfer the series
from (optional)}

\item{name_sap_to}{The name of the SA-Processing to transfer the series to
(optional)}

\item{verbose}{A boolean to print indications on the processing
status (optional and TRUE by default)}

\item{create_sap}{A boolean to create a new SA-Processing if not existing
(optional)}

\item{replace_series}{A boolean to replace existing series (optional)}
}
\value{
the \code{workspace} ws_to augmented with series present in ws_from and
not already in ws_to
}
\description{
To copy & paste series from one workspace to another
}
\details{
To use this function you need to first launch \code{load_workspace} and after
\code{save_workspace} to save the changes.

\code{name_sap_to} and \code{name_sap_from} refer to the SAP's name and not SAP's
file's name.

The transfer will fail if:
- \code{name_sap_from} doesn't exist
- \code{pos_sap_from} < 0 or exceed the maximum number of SAP
- \code{pos_sap_to} < 0 or exceed the maximum number of SAP
- The arguments \code{pos_sap_from} and \code{name_sap_from} are refering to
differents objects.
- The arguments \code{pos_sap_to} and \code{name_sap_to} are refering to
differents objects.

If \code{name_sap_to} and \code{pos_sap_to} are unspecified, the update will be
performed using the workspaces' first SAProcessing (same for the SAP from).
However if the informations of one on the two SAP (from or to) are specified
(name or position), they will be attributed by default to the other
worskpace.

If \code{name_sap_to} doesn't refer to an existing SAP, a new SAP will be created
(if \code{create_sap} is \code{TRUE}).

If a sa_item has a specification which uses external regressor, you have to
be sure that the regressors are also in the destination workspace.
}
\examples{

library("RJDemetra")
dir_ws <- tempdir()
template_ws <- file.path(system.file("extdata", package = "rjdworkspace"),
                         "WS")
# Moving the WS in a temporary environment
copy_ws(
    ws_name = "ws_output",
    from = template_ws,
    to = dir_ws
)
copy_ws(
    ws_name = "ws_input",
    from = template_ws,
    to = dir_ws
)
path_ws_from <- file.path(dir_ws, "ws_input.xml")
path_ws_to <- file.path(dir_ws, "ws_output.xml")
ws_input <- load_workspace(path_ws_from)
ws_output <- load_workspace(path_ws_to)

# Existing SAP
transfer_series(
    ws_from = ws_input,
    ws_to = ws_output,
    name_sap_from = "SAProcessing-1",
    name_sap_to = "SAProcessing-1",
    verbose = TRUE
)

transfer_series(
    ws_from = ws_input,
    ws_to = ws_output,
    pos_sap_from = 1,
    pos_sap_to = 1,
    verbose = TRUE
)

# Existing series
transfer_series(
    ws_from = ws_input, ws_to = ws_output,
    pos_sap_from = 2,
    pos_sap_to = 2,
    verbose = TRUE,
    replace_series = FALSE
)
transfer_series(
    ws_from = ws_input, ws_to = ws_output,
    pos_sap_from = 2,
    pos_sap_to = 2,
    verbose = TRUE,
    replace_series = TRUE
)

# Create a new SAP
# transfer_series(ws_from = ws_input, ws_to = ws_output,
#                 name_sap_from = "SAProcessing-1",
#                 name_sap_to = "New-SAProcessing-from-R",
#                 verbose = TRUE,
#                 create = FALSE)

transfer_series(
    ws_from = ws_input, ws_to = ws_output,
    name_sap_from = "SAProcessing-1",
    name_sap_to = "New-SAProcessing-from-R",
    verbose = TRUE,
    create = TRUE
)

RJDemetra::save_workspace(workspace = ws_output, file = path_ws_to)

}
