% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoiseKrigingClass.R
\name{update_simulate.NoiseKriging}
\alias{update_simulate.NoiseKriging}
\title{Update previous simulation of a \code{NoiseKriging} model object.}
\usage{
\method{update_simulate}{NoiseKriging}(object, y_u, noise_u, X_u, ...)
}
\arguments{
\item{object}{S3 NoiseKriging object.}

\item{y_u}{Numeric vector of new responses (output).}

\item{noise_u}{Numeric vector of new noise variances (output).}

\item{X_u}{Numeric matrix of new input points.}

\item{...}{Ignored.}
}
\value{
a matrix with \code{nrow(x)} rows and \code{nsim}
    columns containing the simulated paths at the inputs points
    given in \code{x}.
}
\description{
This method draws paths of the stochastic process conditional on the values at the input points used in the
fit, plus the new input points and their values given as argument (knonw as 'update' points).
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
plot(f)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + X/10 * rnorm(nrow(X))
points(X, y, col = "blue")

k <- NoiseKriging(y, (X/10)^2, X, "matern3_2")

x <- seq(from = 0, to = 1, length.out = 101)
s <- k$simulate(nsim = 3, x = x, will_update = TRUE)

lines(x, s[ , 1], col = "blue")
lines(x, s[ , 2], col = "blue")
lines(x, s[ , 3], col = "blue")

X_u <- as.matrix(runif(3))
y_u <- f(X_u) + 0.1 * rnorm(nrow(X_u))
points(X_u, y_u, col = "red")

su <- k$update_simulate(y_u, rep(0.1^2,3), X_u)

lines(x, su[ , 1], col = "blue", lty=2)
lines(x, su[ , 2], col = "blue", lty=2)
lines(x, su[ , 3], col = "blue", lty=2)
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
