% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preliminary.R
\name{mis.angle}
\alias{mis.angle}
\alias{mis.angle.SO3}
\alias{mis.angle.Q4}
\title{Misorientation angle}
\usage{
mis.angle(x)

\method{mis.angle}{SO3}(x)

\method{mis.angle}{Q4}(x)
}
\arguments{
\item{x}{\eqn{n\times p}{n-by-p} matrix where each row corresponds to a random rotation in matrix (\eqn{p=9}) or quaternion (\eqn{p=4}) form.}
}
\value{
Angle of rotation.
}
\description{
Compute the misorientation angle of a rotation.
}
\details{
Every rotation can be thought of as some reference coordinate system rotated about an axis through an angle.  These quantities
are referred to as the misorientation axis and misorientation angle, respectively, in the material sciences literature.
This function returns the misorentation angle associated with a rotation assuming the reference coordinate system
is the identity.
}
\examples{
rs <- rcayley(20, kappa = 20)
Rs <- genR(rs, S = id.SO3)
mis.angle(Rs)

#If the central orientation is id.SO3 then mis.angle(Rs) and abs(rs) are equal
all.equal(mis.angle(Rs), abs(rs))  #TRUE

#For other reference frames, the data must be centered first
S <- genR(pi/2)
RsS <- genR(rs, S = S)
mis.axis(RsS-S)
all.equal(mis.angle(RsS-S),abs(rs)) #TRUE

#If the central orientation is NOT id.SO3 then mis.angle(Rs) and abs(rs) are usual unequal
Rs <- genR(rs, S = genR(pi/8))
all.equal(mis.angle(Rs), abs(rs))  #Mean relative difference > 0
}
\seealso{
\code{\link{mis.axis}}
}
