% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfit.prev.R
\name{summary.survfit.prev}
\alias{summary.survfit.prev}
\title{Obtain N-year survival probability estimates.}
\usage{
\method{summary}{survfit.prev}(object, years = c(1, 3, 5), ...)
}
\arguments{
\item{object}{A \code{survfit.prev} object.}

\item{years}{A vector of years for which to estimate survival probability
from the bootstrapped survival curves.}

\item{...}{Arguments passed to main \code{summary} function.}
}
\value{
None, displays the survival probabilities to screen as a side-effect.
}
\description{
Summarises survival information at pre-specified years of interest on a
\code{survfit.prev} object.
}
\details{
Survival probability is estimated as the mean of the bootstrapped survival
curves at a specific timepoint, with 2.5% and 97.5% quantiles providing 95%
confidence intervals. Survival probability can only be estimated at time
points less than the maximum survival time in the original dataset that the
\code{prevalence} object was fitted to.
}
\examples{
data(prevsim)

\dontrun{
prev_obj <- prevalence(Surv(time, status) ~ age(age) + sex(sex) +
                       entry(entrydate) + event(eventdate),
                       data=prevsim, num_years_to_estimate = c(5, 10),
                       population_size=1e6, start = "2005-09-01",
                       num_reg_years = 8, cure = 5)

survobj <- survfit(prev_obj, newdata=list(age=65, sex=0))

summary(survobj)

summary(survobj, years=c(1, 3, 5, 7))
}

}

