% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsat_cloud_mask.R
\name{rsat_cloudMask}
\alias{rsat_cloudMask}
\alias{rsat_cloudMask,rtoi-method}
\alias{cloud_mask,rtoi}
\title{Create cloud mask from an rtoi}
\usage{
rsat_cloudMask(x, ...)

\S4method{rsat_cloudMask}{rtoi}(x, products = "ALL", verbose = FALSE, overwrite = FALSE, ...)
}
\arguments{
\item{x}{rtoi object from which cloud masks are computed.}

\item{...}{additional arguments}

\item{products}{the name of the dataset from which cloud masks are computed.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}
}
\value{
nothing. The cloud masks will be save in the hard drive.
Use get_stars to get the variables.
}
\description{
Create cloud mask from an rtoi
}
\examples{
\dontrun{
## Smooth data in rtoi
library(rsat)

# create a copy of pamplona in temp file
file.copy(from=system.file("ex/Pamplona",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

# load example rtoi
pamplona <- read_rtoi(file.path(tempdir(),"Pamplona"))

rsat_cloudMask(pamplona)

rsat_list_data(pamplona)
}
}
