% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/records.R, R/rtoi.R
\name{sat_name}
\alias{sat_name}
\alias{sat_name,records-method}
\alias{sat_name,records}
\alias{sat_name,rtoi-method}
\alias{sat_name,rtoi}
\title{Get the name of the satellite(s) from a \code{records} or an \code{rtoi}}
\usage{
sat_name(x)

\S4method{sat_name}{records}(x)

\S4method{sat_name}{rtoi}(x)
}
\arguments{
\item{x}{a \code{records} or an \code{rtoi} object.}
}
\value{
the name of the satellite
}
\description{
Get the name of the satellite(s) from a \code{records} or an \code{rtoi}
}
\examples{
\dontrun{
# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))
# get the records
rcds <- records(navarre)
# coerce the records to dataframe
sat_name(rcds)
}
}
