% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_model_api.R
\name{validate_query}
\alias{validate_query}
\title{Validate Query Structure}
\usage{
validate_query(query)
}
\arguments{
\item{query}{A list containing the query data.}
}
\value{
Invisibly returns TRUE if validation passes.
Throws an error If the query structure is invalid or missing required keys.
}
\description{
Validates the structure and contents of the query based on the v2.0 model.
This function checks that the query is a list and contains all required keys.
}
\examples{
# Create a valid query
query <- get_valid_query()
validate_query(query) # Passes validation

# Example with invalid query (missing required key)
\dontrun{
invalid_query <- list(inputs = list(), mode = "mean estimation")
validate_query(invalid_query) # Throws error for missing modality
}
}
