% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REPEATED_DDCt.r
\name{REPEATED_DDCt}
\alias{REPEATED_DDCt}
\title{Fold change (\eqn{\Delta \Delta C_T} method) analysis of repeated measure qPCR data}
\usage{
REPEATED_DDCt(
  x,
  numberOfrefGenes,
  factor,
  block,
  x.axis.labels.rename = "none",
  p.adj = "none",
  plot = TRUE,
  plotType = "RE"
)
}
\arguments{
\item{x}{input data frame in which the first column is id, 
followed by the factor column(s) which include at least time. 
The first level of time in data frame is used as calibrator or reference level.
Additional factor(s) may also be present. Other columns are efficiency and Ct values of target and reference genes.
 \strong{NOTE:} In the "id" column, a unique number is assigned to each individual from which samples have been taken over time, 
for example see \code{data_repeated_measure_1}, 
all the three number 1 indicate one individual which has been sampled over three different time courses.
See \href{../doc/vignette.html}{\code{vignette}}, section "data structure and column arrangement" for details.}

\item{numberOfrefGenes}{number of reference genes which is 1 or 2 (Up to two reference genes can be handled).
as reference or calibrator which is the reference level or sample that all others are compared to. Examples are untreated 
of time 0. The FC value of the reference or calibrator level is 1 because it is not changed compared to itself.
If NULL, the first level of the main factor column is used as calibrator.}

\item{factor}{the factor for which the FC values is analysed. The first level of the specified factor in the input data frame is used as calibrator.}

\item{block}{column name of the block if there is a blocking factor (for correct column arrangement see example data.). 
Block effect is usually considered as random and its interaction with any main effect is not considered.}

\item{x.axis.labels.rename}{a vector replacing the x axis labels in the bar plot}

\item{p.adj}{Method for adjusting p values}

\item{plot}{if \code{FALSE}, prevents the plot.}

\item{plotType}{Plot based on "RE" (relative expression) or "log2FC" (log2 fold change).}
}
\value{
A list with 5 elements:
\describe{
  \item{Final_data}{Input data frame plus the weighted Delat Ct values (wDCt)}
  \item{lm}{lm of factorial analysis-tyle}
  \item{ANOVA_table}{ANOVA table}
  \item{FC Table}{Table of FC values, significance, confidence interval and standard error with the lower and upper limits for the selected factor levels.}
  \item{Bar plot of FC values}{Bar plot of the fold change values for the main factor levels.}
}
}
\description{
\code{REPEATED_DDCt} function performs fold change (\eqn{\Delta \Delta C_T} method) 
analysis of observations repeatedly taken over different time courses. 
Data may be obtained over time from a uni- or multi-factorial experiment. The bar plot of the fold changes (FC) 
values along with the standard error (se) or confidence interval (ci) is also returned by the \code{REPEATED_DDCt} function.
}
\details{
The \code{REPEATED_DDCt} function performs fold change (FC) analysis of observations repeatedly taken over time. 
The intended factor (could be time or any other factor) is defined for the analysis by the \code{factor} argument, 
then the function performs FC analysis on its levels
so that the first levels (as appears in the input data frame) is used as reference or calibrator. 
The function returns FC values along with confidence interval and standard error for the FC values.
}
\examples{

REPEATED_DDCt(data_repeated_measure_1,
            numberOfrefGenes = 1,
            factor = "time", block = NULL)

REPEATED_DDCt(data_repeated_measure_2,
             numberOfrefGenes = 1,
             factor = "time", block = NULL)
                                                       
                                                       
}
\author{
Ghader Mirzaghaderi
}
