% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{NCA_mkactive_ana}
\alias{NCA_mkactive_ana}
\title{Fetch PKNCA Results Object}
\usage{
NCA_mkactive_ana(state, ana_id)
}
\arguments{
\item{state}{NCA state from \code{NCA_fetch_state()}}

\item{ana_id}{Analysis ID to make active.}
}
\value{
State with the analysis ID made active.
JMH add to example script below
}
\description{
Fetches the PKNCA output for a specified analysis
}
\examples{
library(ruminate)
# Module IDs                                                                   
id     = "NCA"                                                                 
id_UD  = "UD"                                                                  
id_DW  = "DW"                                                                  
id_ASM = "ASM"                                                                 
# We need session and input variables to be define                             
 sess_res = NCA_test_mksession(session=list(),                                 
      id     = id,                                                             
      id_UD  = id_UD,                                                          
      id_DW  = id_DW,                                                          
      id_ASM = id_ASM,
      full_session=FALSE)
                                                                               
# Extracting the session and input variables                                   
session      = sess_res$session                                                
input        = sess_res$input                                                  
react_state  = list()                                                          
                                                                               
# We also need configuration files                                             
FM_yaml_file  = system.file(package = "formods",  "templates", "formods.yaml") 
MOD_yaml_file = system.file(package = "ruminate", "templates", "NCA.yaml")     
                                                                               
# Getting the current module state                                             
state = NCA_fetch_state(id             = id,                                   
                       input           = input,                                
                       session         = session,                              
                       FM_yaml_file    = FM_yaml_file,                         
                       MOD_yaml_file   = MOD_yaml_file,                        
                       id_ASM          = id_ASM,                               
                       id_UD           = id_UD,                                
                       id_DW           = id_DW,                                
                       react_state     = react_state)                          
                                                                               
# Pulls out the active analysis                                                
current_ana = NCA_fetch_current_ana(state)

# This will get the dataset associated with this analysis
ds = NCA_fetch_ana_ds(state, current_ana)

# After making changes you can update those in the state
state = NCA_set_current_ana(state, current_ana)

# You can use this to check the current analysis
current_ana = NCA_process_current_ana(state)

# This will pull out the code for the module
fc_res = NCA_fetch_code(state)

# This will use patterns defined for the site to detect
# columns. In this example we are detecting the id column:
id_col = NCA_find_col(
  patterns = state[["MC"]][["detect_col"]][["id"]],
  dscols   = names(ds$DS))

# This creates a new analysis
state = NCA_new_ana(state)
}
