% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTS.R
\name{toTrialDuration}
\alias{toTrialDuration}
\title{Convert event data to trial duration data
A helper function to create a custom event table.
The observation time will start from the first event time (baseline) and end at trial duration.
The interval is the spacing between each observation.}
\usage{
toTrialDuration(ev, trialEnd, interval, writeDir = NULL)
}
\arguments{
\item{ev}{event data}

\item{trialEnd}{extend trial duration. Must be same time unit as event data}

\item{interval}{observation interval. Must be same time unit as event data}

\item{writeDir}{if not NULL, write the output to a csv file}
}
\description{
Convert event data to trial duration data
A helper function to create a custom event table.
The observation time will start from the first event time (baseline) and end at trial duration.
The interval is the spacing between each observation.
}
\examples{
 # Create event table with unique time for each ID
 ev = et(data.frame(id = rep(1:10, 3),  time = runif(min = 10, max = 20, n = 30)))

 # select the duration and spacing interval (assuming time is in years)
 toTrialDuration(ev, trialEnd = 1.5, interval = 0.2)

}
\author{
Omar Elashkar
}
