% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/breaks.R, R/tab.R
\name{chop_evenly}
\alias{chop_evenly}
\alias{brk_evenly}
\alias{tab_evenly}
\title{Chop into equal-width intervals}
\usage{
chop_evenly(x, intervals, ..., close_end = TRUE)

brk_evenly(intervals)

tab_evenly(x, intervals, ...)
}
\arguments{
\item{x}{A vector.}

\item{intervals}{Integer: number of intervals to create.}

\item{...}{Passed to \code{\link[=chop]{chop()}}.}

\item{close_end}{Logical. Close last break at right? (If \code{left} is \code{FALSE},
close first break at left?)}
}
\value{
\verb{chop_*} functions return a \code{\link{factor}} of the same length as \code{x}.

\verb{brk_*} functions return a \code{\link{function}} to create \code{breaks}.

\verb{tab_*} functions return a contingency \code{\link[=table]{table()}}.
}
\description{
\code{chop_evenly()} chops \code{x} into \code{intervals} intervals of equal width.
}
\details{
\code{chop_evenly()} sets \code{close_end = TRUE} by default.
}
\examples{
chop_evenly(0:10, 5)

}
\seealso{
Other chopping functions: 
\code{\link{chop}()},
\code{\link{chop_equally}()},
\code{\link{chop_fn}()},
\code{\link{chop_mean_sd}()},
\code{\link{chop_n}()},
\code{\link{chop_proportions}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
