% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/breaks.R, R/tab.R
\name{chop_width}
\alias{chop_width}
\alias{brk_width}
\alias{brk_width.default}
\alias{tab_width}
\title{Chop into fixed-width intervals}
\usage{
chop_width(x, width, start, ..., left = sign(width) > 0)

brk_width(width, start)

\method{brk_width}{default}(width, start)

tab_width(x, width, start, ..., left = sign(width) > 0)
}
\arguments{
\item{x}{A vector.}

\item{width}{Width of intervals.}

\item{start}{Starting point for intervals. By default the smallest
finite \code{x} (largest if \code{width} is negative).}

\item{...}{Passed to \code{\link[=chop]{chop()}}.}

\item{left}{Logical. Left-closed or right-closed breaks?}
}
\value{
\verb{chop_*} functions return a \code{\link{factor}} of the same length as \code{x}.

\verb{brk_*} functions return a \code{\link{function}} to create \code{breaks}.

\verb{tab_*} functions return a contingency \code{\link[=table]{table()}}.
}
\description{
\code{chop_width()} chops \code{x} into intervals of fixed \code{width}.
}
\details{
If \code{width} is negative, \code{chop_width()} sets \code{left = FALSE} and intervals will
go downwards from \code{start}.
}
\examples{
chop_width(1:10, 2)

chop_width(1:10, 2, start = 0)

chop_width(1:9, -2)

chop(1:10, brk_width(2, 0))

tab_width(1:10, 2, start = 0)

}
\seealso{
\link{brk_width-for-datetime}

Other chopping functions: 
\code{\link{chop}()},
\code{\link{chop_equally}()},
\code{\link{chop_evenly}()},
\code{\link{chop_fn}()},
\code{\link{chop_mean_sd}()},
\code{\link{chop_n}()},
\code{\link{chop_proportions}()},
\code{\link{chop_quantiles}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
