% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Seurat_Iterative.R
\name{Iterate_VlnPlot_scCustom}
\alias{Iterate_VlnPlot_scCustom}
\title{Iterative Plotting of Gene Lists using VlnPlot_scCustom}
\usage{
Iterate_VlnPlot_scCustom(
  seurat_object,
  features,
  colors_use = NULL,
  pt.size = NULL,
  group.by = NULL,
  split.by = NULL,
  file_path = NULL,
  file_name = NULL,
  file_type = NULL,
  single_pdf = FALSE,
  output_width = NULL,
  output_height = NULL,
  raster = NULL,
  dpi = 600,
  ggplot_default_colors = FALSE,
  color_seed = 123,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{features}{vector of features to plot.}

\item{colors_use}{color palette to use for plotting.  By default if number of levels plotted is less than
or equal to 36 it will use "polychrome" and if greater than 36 will use "varibow" with shuffle = TRUE
both from \code{DiscretePalette_scCustomize}.}

\item{pt.size}{point size for plotting.}

\item{group.by}{Name of one or more metadata columns to group (color) plot by (for example, orig.ident);
default is the current active.ident of the object.}

\item{split.by}{Feature to split plots by (i.e. "orig.ident").}

\item{file_path}{directory file path and/or file name prefix.  Defaults to current wd.}

\item{file_name}{name suffix and file extension.}

\item{file_type}{File type to save output as.  Must be one of following: ".pdf", ".png", ".tiff", ".jpeg", or ".svg".}

\item{single_pdf}{saves all plots to single PDF file (default = FALSE).  `file_type`` must be .pdf.}

\item{output_width}{the width (in inches) for output page size.  Default is NULL.}

\item{output_height}{the height (in inches) for output page size.  Default is NULL.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 100,000 total points plotted (# Cells x # of features).}

\item{dpi}{dpi for image saving.}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{VlnPlot}}.}
}
\value{
Saved plots
}
\description{
Create and Save plots for Gene list with Single Command
}
\examples{
\dontrun{
Iterate_VlnPlot_scCustom(seurat_object = object, features = DEG_list, colors = color_list,
file_path = "plots/", file_name = "_vln", file_type = ".jpg", dpi = 600)
}

}
\concept{iterative_plotting}
