% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Updated_MGI_Symbols}
\alias{Updated_MGI_Symbols}
\title{Update MGI Gene Symbols}
\usage{
Updated_MGI_Symbols(input_data, update_symbol_data = NULL, verbose = TRUE)
}
\arguments{
\item{input_data}{Data source containing gene names.  Accepted formats are:
\itemize{
\item \code{charcter vector}
\item \code{Seurat Objects}
\item \code{data.frame}: genes as rownames
\item \code{dgCMatrix/dgTMatrix}: genes as rownames
\item \code{tibble}: genes in first column
}}

\item{update_symbol_data}{logical, whether to update cached MGI data, default is NULL.
If \code{NULL} BiocFileCache will check and prompt for update if cache is stale.
If \code{FALSE} the BiocFileCache stale check will be skipped and current cache will be used.
If \code{TRUE} the BiocFileCache stale check will be skipped and MGI data will be downloaded.}

\item{verbose}{logical, whether to print results detailing numbers of symbols, found, updated,
and not found; default is TRUE.}
}
\value{
data.frame containing columns: input_features, Approved_Symbol (already approved; output unchanged), Not_Found_Symbol (symbol not in MGI; output unchanged), Updated_Symbol (new symbol from MGI; output updated).
}
\description{
Update mouse gene symbols using data from MGI  This function will store cached data in package directory using (BiocFileCache).  Use of this function requires internet connection on first use (or if setting \code{update_symbol_data = TRUE}).  Subsequent use does not require connection and will pull from cached data.
}
\examples{
\dontrun{
new_names <- Updated_MGI_Symbols(input_data = Seurat_Object)
}

}
\concept{misc_util}
