% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{closed_breaks_log2}
\alias{closed_breaks_log2}
\title{Closed breaks for log scale}
\usage{
closed_breaks_log2(lims)
}
\arguments{
\item{lims}{Vector with lower and upper limits (in that order) of the data
that you want breaks for.}
}
\value{
Numeric vector with breaks.
}
\description{
Finds breaks that are powers of 2,
and forces inclusion of upper and lower limits
(displaying the closed interval).
Including limits specifically is particularly useful for ggplot2's color/fill,
as it
emphasizes the meaning of maximal/minimal color intensities (see examples).
}
\details{
The \code{feat} function uses \code{closed_breaks_log2} to color by
gene expression,
where the maximal expression gives valuable
intuition for a gene's overall expression strength.
For x- or y-axis (\code{scale_*_log10}),
I still recommend \code{breaks_log} from the scales package.
}
\examples{
# closed breaks include maximum, breaks_log do not:
closed_breaks_log2(lims = c(.01, 977.1))
scales::breaks_log()(c(.01, 977.1))
}
\seealso{
\code{\link[scUtils]{closed_labels}}
}
