% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{feat}
\alias{feat}
\title{Feature Plot}
\usage{
feat(embedding, expression, legend_name = "Expression")
}
\arguments{
\item{embedding}{A matrix/data.frame/tibble/... with exactly two columns.
If colnames are missing, the axis will be named "Dim1" and "Dim2".
Other classes than matrix/data.frame/tibble are possible, as long as
\code{data.frame(embedding)}) produces a numeric data.frame.}

\item{expression}{Numeric vector with expression values of the gene of
interest. Order has to correspond to the row order in \code{embedding}.
Typically, \code{expression} is normalized gene expression and we recommend
\code{k/s/mean(1/s)}, where \code{k} are UMI counts for the gene of interest
and \code{s} are totalUMI of the cell (aka library size).}

\item{legend_name}{Text displayed above the legend. Most commonly the name
of the displayed gene.}
}
\value{
A \code{ggplot2} object storing a colored scatter plot.
}
\description{
Highlight gene expression data in a 2D-embedding (UMAP, tSNE, etc.).
}
\details{
This function discourages customization on purpose, because it
bundles geoms, themes and settings that I found important for
visualizing gene expression in scRNAseq data:

\itemize{
 \item coord_fixed, to avoid distortion of embeddings
 \item geom_point with size=.4, to ameliorate overplotting
 \item No background grid, because distances and axis units
 in embeddings do not
 carry meaning for most dimensionality reduction techniques.
 \item Intensity-coded color scales (viridis) displayed with
 log2-transformation. Makes visualization independent of colorblindness
 and appropriate for gene expression data (which is usually Log Normal
 distributed).
 \item Color scale breaks are displayed as 'closed interval', i.e.
 \code{max(expression)} and \code{min(expression)} are the most extreme
 breaks. Rounding makes them human-readable. This functionality is provided
 by \link[scUtils]{closed_breaks_log2} and \link[scUtils]{closed_labels}.
      }

If you insist on customizing, think of this function as a great starting point, you can simply
copy-paste the code after typing \code{feat} into your
console.
}
\examples{
 # expression goes from 0 to 22:
 set.seed(100)
 feat(matrix(rnorm(2000, c(.1, 3)), ncol=2), rpois(1000, c(.1, 11)))
 # expression goes from 2 to 52:
 set.seed(100)
 feat(matrix(rnorm(2000, c(.1, 3)), ncol=2), rpois(1000, c(10, 31)))
}
\seealso{
\code{\link[ggplot2]{ggplot}},
 \code{\link[scUtils]{closed_labels}},
 \code{\link[scUtils]{closed_breaks_log2}}
}
