% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier.R
\name{outlier}
\alias{outlier}
\title{Handling outliers in single-case data}
\usage{
outlier(
  data,
  dvar,
  pvar,
  mvar,
  method = c("MAD", "Cook", "SD", "CI"),
  criteria = 3.5
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{method}{Specifies the method for outlier identification. Set \code{method = "MAD"} for mean average deiviation, \code{method = "SD"} for standard
deviations, \code{method = "CI"} for confidence intervals, \code{method = "Cook"} for
Cook's Distance based on the Piecewise Linear Regression Model.}

\item{criteria}{Specifies the criteria for outlier identification. Based on
the \code{method} setting.}
}
\value{
\tabular{ll}{
    \tab  \cr
   \code{data} \tab A single-case data frame with substituted outliers. \cr
   \code{dropped.n} \tab A list with the number of dropped data points for each single-case. \cr
   \code{dropped.mt} \tab A list with the measurement-times of dropped data points for each single-case (values are based on the mt variable of each single-case data frame). \cr
   \code{sd.matrix} \tab A list with a matrix for each case with values for the upper and lower boundaries based on the standard deviation. \cr
   \code{ci.matrix} \tab A list with a matrix for each single-case with values for the upper and lower boundaries based on the confidence interval. \cr
   \code{cook} \tab A list of Cook's Distances for each measurement of each single-case. \cr
   \code{criteria} \tab Criteria used for outlier analysis. \cr
   \code{N} \tab Number of single-cases. \cr
   \code{case.names} \tab Case identifier. \cr
}
}
\description{
Identifies and drops outliers within a single-case data frame (scdf).
}
\details{
For \code{method = "SD"}, \code{criteria = 2} would refer t0 two standard
deviations. For \code{method = "MAD"}, \code{criteria = 3.5} would refer to 3.5 times
the mean average deviation. For \code{method = "CI"}, \code{criteria = 0.99} would
refer to a 99 percent confidence interval. For \code{method = "cook"}, \code{criteria = "4/n"} would refer to a Cook's Distance greater than 4/n.
}
\examples{

## Identify outliers using 1.5 standard deviations as criterion
susanne <- random_scdf(level = 1.0)
res_outlier <- outlier(susanne, method = "SD", criteria = 1.5)
res_outlier

## Identify outliers in the original data from Grosche (2011)
## using Cook's Distance greater than 4/n as criterion
res_outlier <- outlier(Grosche2011, method = "Cook", criteria = "4/n")
res_outlier

}
\seealso{
Other data manipulation functions: 
\code{\link{add_l2}()},
\code{\link{as.data.frame.scdf}()},
\code{\link{as_scdf}()},
\code{\link{fill_missing}()},
\code{\link{moving_median}()},
\code{\link{ranks}()},
\code{\link{rescale}()},
\code{\link{scdf}()},
\code{\link{select_cases}()},
\code{\link{set_vars}()},
\code{\link{shift}()},
\code{\link{smooth_cases}()},
\code{\link{standardize}()},
\code{\link{truncate_phase}()}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
\keyword{manip}
