% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dw_data_tabulate.R
\name{plot.datawizard_tables}
\alias{plot.datawizard_tables}
\alias{plot.datawizard_table}
\title{Plot tabulated data.}
\usage{
\method{plot}{datawizard_tables}(
  x,
  label_values = TRUE,
  show_na = "if_any",
  na_label = "(Missing)",
  error_bar = TRUE,
  ci = 0.95,
  color_fill = "#87CEFA",
  color_error_bar = "#607B8B",
  ...
)

\method{plot}{datawizard_table}(
  x,
  label_values = TRUE,
  show_na = "if_any",
  na_label = "(Missing)",
  error_bar = TRUE,
  ci = 0.95,
  color_fill = "#87CEFA",
  color_error_bar = "#607B8B",
  ...
)
}
\arguments{
\item{x}{Object created by \code{datawizard::data_tabulate()}.}

\item{label_values}{Logical. Should values and percentages be displayed at the
top of each bar.}

\item{show_na}{Should missing values be dropped? Can be \code{"if_any"} (default)
to show the missing category only if any missing values are present,
\code{"always"} to always show the missing category, or \code{"never"} to never show
the missing category.}

\item{na_label}{The label given to missing values when they are shown.}

\item{error_bar}{Logical. Should error bars be displayed? If \code{TRUE},
confidence intervals computed using the Wilson method are shown. See Brown
et al. (2001) for details.}

\item{ci}{Confidence Interval (CI) level. Defaults to \code{0.95} (\verb{95\%}).}

\item{color_fill}{Color to use for category columns (default: \code{"#87CEFA"}).}

\item{color_error_bar}{Color to use for error bars (default: \code{"#607B8B"}).}

\item{...}{Unused}
}
\description{
Plot tabulated data.
}
\references{
Brown, L. D., Cai, T. T., & Dasgupta, A. (2001).
Interval estimation for a binomial proportion.
\emph{Statistical Science}, \emph{16}(2), 101-133. \doi{10.1214/ss/1009213286}
}
