% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_metro.R
\name{scale_color_metro}
\alias{scale_color_metro}
\alias{scale_color_metro_d}
\alias{scale_color_metro_c}
\alias{scale_colour_metro}
\alias{scale_colour_metro_c}
\alias{scale_colour_metro_d}
\alias{scale_fill_metro}
\alias{scale_fill_metro_d}
\alias{scale_fill_metro_c}
\title{Metro color palette}
\usage{
scale_color_metro(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_metro_d(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_metro_c(
  palette = NULL,
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_metro(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_metro_c(
  palette = NULL,
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_metro_d(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_fill_metro(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_metro_d(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_metro_c(
  palette = NULL,
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)
}
\arguments{
\item{palette}{Character name of palette. Depending on the color scale, can
be one of \code{"full"}, \code{"ice"}, \code{"rainbow"}, \code{"complement"}, \code{"contrast"},
\code{"light"} (for dark themes), \code{"black_first"}, \code{full_original}, or
\code{black_first_original}. The latter three options are especially for the
Okabe-Ito color palette. The default is \code{NULL} and either \code{"contrast"} or
\code{"gradient"} is used (depending on whether \code{discrete} is \code{TRUE} or \code{FALSE}),
which are the two scale useful for discrete or gradient color scales,
respectively.}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{aesthetics}{A vector of names of the aesthetics that this scale
should be applied to (e.g., \code{c('color', 'fill')}).}

\item{...}{Additional arguments to pass to \code{\link[=colorRampPalette]{colorRampPalette()}}.}
}
\description{
The palette based on Metro \href{https://materialui.co/metrocolors}{Metro colors}.
Use \code{scale_color_metro_d} for \emph{discrete} categories and \code{scale_color_metro_c}
for a \emph{continuous} scale, or use the \code{discrete} argument in
\code{scale_color_metro()}.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_boxplot() +
  theme_modern() +
  scale_fill_metro()

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_violin() +
  theme_modern() +
  scale_fill_metro(palette = "ice")

ggplot(iris, aes(x = Petal.Length, y = Petal.Width, color = Sepal.Length)) +
  geom_point() +
  theme_modern() +
  scale_color_metro(discrete = FALSE)
}
