% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_tracker.R
\name{sst_rt_serp_history}
\alias{sst_rt_serp_history}
\title{Get search results history in search region by keywords}
\usage{
sst_rt_serp_history(
  api_token,
  project_id,
  region_id,
  date_from,
  date_to,
  keywords,
  sort = "keyword",
  order = "desc",
  page = 1,
  size = 100,
  return_method = "list"
)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{project_id}{(required) The ID of your project in Serpstat. You can
find this ID in the URL of any rank tracker report. As an example, in
https://serpstat.com/rank-tracker/keywords/12345/positions?get_params the
ID would be 12345.}

\item{region_id}{(required) The ID of a region returned by
\code{\link{sst_rt_project_regions}}.}

\item{date_from}{(optional) The date string in 'YYYY-MM-DD' format to
specify the initial date of retrieved data.}

\item{date_to}{(optional) The date string in 'YYYY-MM-DD' format to
specify the final date of retrieved data. Must not exceed date_from + 30
days.}

\item{keywords}{(optional) A vector of keywords for witch the data should be
retrieved. Maximum 1000 keywords per request.}

\item{sort}{(optional) Must be one of 'keyword' (default) to sort the
results alphabetically or 'date' to sort the results by date.}

\item{order}{(optional) The sorting order. Must be one of string 'desc'
(default) for descending sorting or 'asc' for ascending sorting.}

\item{page}{(optional) Page number if there are many pages in response. The
default value is 1.}

\item{size}{(optional) Page size. Must be one of 20, 50, 100, 200, 500.The
default value is 100.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}
}
\value{
Returns the search engine results for specific dates and region
  including positions and URLs.
}
\description{
This method method returns top 100 search results in Google and top 50
search results in Yandex by region and project keywords.
}
\section{API rows consumption}{
 0
}

\examples{
\dontrun{
api_token  <- 'api_token'
project_id <- 12345
region_id  <- sst_rt_project_regions(
  api_token  = api_token,
  project_id = project_id
  )$data$regions[[1]]$id
sst_rt_serp_history(
  api_token     = api_token,
  project_id    = project_id,
  region_id     = region_id,
  date_from     = '2020-12-01',
  date_to       = '2020-12-30',
  keywords      = c('seo', 'ppc', 'serpstat'),
  sort          = 'keyword',
  order         = 'desc',
  page          = 1,
  size          = 100,
  return_method = 'list'
)
}
}
