% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcr_portfolio.R
\name{sfcr_portfolio}
\alias{sfcr_portfolio}
\title{Find a valid matrix of portfolio parameters}
\usage{
sfcr_portfolio(m, known)
}
\arguments{
\item{m}{A matrix of parameter names}

\item{known}{A named vector of known parameters. One entry for each symmetry
condition is enough to find a valid matrix.}
}
\description{
The \code{sfcr_portfolio()} function calculates a valid matrix of portfolio
parameters by applying the symmetry condition and then filling the missing
rows accordingly to the vertical and horizontal adding-up constraints.
}
\details{
This function calculates only the values of the rates of return matrix, i.e.,
the internal matrix. The adding-up constraint number 1, that calculates the
share of assets in the net wealth and the impact of regular income to wealth
ratio must be calculated separately.

If supplied with insufficient parameters, the function will return a
matrix with NA values.

This function requires at least (n^2 - n)/2 known parameters to find a valid portfolio
matrix, where n is the number of rows/columns. This is achieved by setting known parameters
outside the diagonal and not on symmetrical entries, i.e., not lambda12 and lambda21, for
example.
}
\examples{
j1 <- matrix(paste0("lambda", c(11:14, 21:24, 31:34, 41:44)), ncol = 4, nrow = 4, byrow = TRUE)
j2 <- c(lambda12 = 0, lambda13 = 0, lambda14 = 0, lambda23 = -15, lambda24 = -15, lambda34 = -15)

sfcr_portfolio(j1, j2)

}
\author{
João Macalós
}
