% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglg.R
\name{rglg}
\alias{rglg}
\title{Random number generation for a generalized log-gamma distribution}
\usage{
rglg(n, location, scale, shape)
}
\arguments{
\item{n}{numeric, size of the random sample.}

\item{location}{numeric, represents the location parameter of a generalized log-gamma distribution. Default value is 0.}

\item{scale}{numeric, represents the scale parameter of a generalized log-gamma distribution. Default value is 1.}

\item{shape}{numeric, represents the shape parameter of a generalized log-gamma distribution. Default value is 1.}
}
\value{
A vector of size n with the generalized log-gamma random values.
}
\description{
\code{rglg} is used to generate random numbers for a generalized log-gamma distribution.
}
\examples{
u <- rglg(100, location = 0, scale = 1, shape = 1)
hist(u)
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
