% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simTVP.R
\name{simTVP}
\alias{simTVP}
\title{Generate synthetic data from a time-varying parameter model}
\usage{
simTVP(
  N = 200,
  d = 3,
  sv = FALSE,
  sigma2 = 1,
  theta,
  beta_mean,
  sv_mu = 0,
  sv_phi = 0.98,
  sv_sigma2 = 0.2
)
}
\arguments{
\item{N}{integer > 2. Indicates the length of the time series to be
generated. The default value is 200.}

\item{d}{positive integer. Indicates the number of covariates to simulate.
The default value is 3.}

\item{sv}{logical value. If set to \code{TRUE}, the data will be generated with
stochastic volatility for the errors of the observation equation using \code{\link{svsim}}. The default value is FALSE.}

\item{sigma2}{positive real number. Determines the variance of the errors of the observation
equation. Ignored if sv is \code{TRUE}. The default value is 1.}

\item{theta}{\emph{(optional)} vector containing positive real numbers. If supplied, these determine the variances of the
innovations of the state equation. Otherwise, the elements of \code{theta} are generated from a X^2(1) distribution.
Has to be of length \code{d} or an error will be thrown.}

\item{beta_mean}{\emph{(optional)} vector containing real numbers. If supplied, these determine the mean of the
initial value of the state equation. Otherwise, the elements of \code{beta_mean} are generated from a Normal(0,1) distribution.
Has to be of length \code{d} or an error will be thrown.}

\item{sv_mu}{real number. Determines the mean of the logarithm of the volatility. Ignored if \code{sv} is \code{FALSE}.
The default value is 0.}

\item{sv_phi}{real number between -1 and 1. Determines the persistence of the SV process. Ignored if \code{sv} is \code{FALSE}.
The default value is 0.98.}

\item{sv_sigma2}{positive, real number. Determines the variance of the innovations of the logarithm of the volatility.
Ignored if \code{sv} is \code{FALSE}. The default value is 0.2.}
}
\value{
The value returned is a list object containing:
\item{\code{data}}{data frame that holds the simulated data.}
\item{\code{true_vals}}{list object containing:
  \itemize{
  \item \code{theta}: the values of theta used in the data generating process.
  \item \code{beta_mean}: the values of beta_mean used in the data generating process.
  \item \code{beta}: the true paths of beta used for the data generating process.
  \item \code{sigma2}: the value(s) of sigma2 used in the data generating process.
  }
}
}
\description{
\code{simTVP} generates synthetic data from a time-varying parameter model. The covariates are always
generated i.i.d. from a Normal(0,1) distribution.
}
\examples{
# Generate a time series of length 300
res <- simTVP(N = 300)

# Extract the generated data
data <- res$data

# Now with stochastic volatility
res_sv <- simTVP(N = 300, sv = TRUE)
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
