% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sift.R
\name{sift}
\alias{sift}
\title{Augmented data frame filtering.}
\usage{
sift(.data, sift.col, scope, ...)
}
\arguments{
\item{.data}{A data frame.}

\item{sift.col}{Column name, as symbol, to serve as "sifting/augmenting" dimension. Must be non-missing and coercible to numeric.}

\item{scope}{Specifies augmentation bandwidth relative to "key" observations. Parameter should share the same scale as \code{sift.col}.

If length 1, bandwidth used is +/- \code{scope}.

If length 2, bandwidth used is (-\code{scope[1]}, +\code{scope[2]}).}

\item{...}{Expressions passed to \code{dplyr::\link[dplyr]{filter}}, of which the results serve as the "key" observations. The same data-masking rules used in \code{dplyr::\link[dplyr]{filter}} apply here.}
}
\value{
A sifted data frame, with 2 additional columns:
\itemize{
  \item \code{.cluster <int>}: Identifies resulting group formed by each key observation and its neighboring rows.  When the key observations are close enough together, the clusters will overlap.
  \item \code{.key <lgl>}: \code{TRUE} indicates key observation.
}
}
\description{
Imagine \code{dplyr::\link[dplyr]{filter}} that includes neighboring observations.
Choose how many observations to include by adjusting inputs \code{sift.col} and \code{scope}.
}
\details{
\code{sift()} can be understood as a 2-step process:

\enumerate{
  \item \code{.data} is passed to \code{dplyr::\link[dplyr]{filter}}, using subsetting expression(s) provided in \code{...}. We'll refer to these intermediate results as "key" observations.
  \item For each key observation, \code{sift} expands the row selection bidirectionally along dimension specified by \code{sift.col}. Any row from the original dataset within \code{scope} units of a key observation is captured in the final result.
}

Essentially, this allows us to "peek" at neighboring rows surrounding the key observations.
}
\examples{
# See current events from same timeframe as 2020 Utah Monolith discovery.
sift(nyt2020, pub_date, scope = 2, grepl("Monolith", headline))

# or Biden's presidential victory.
sift(nyt2020, pub_date, scope = 2, grepl("Biden is elected", headline))

# We can specify lower & upper scope to see what happened AFTER Trump tested positive.
sift(nyt2020, pub_date, scope = c(0, 2), grepl("Trump Tests Positive", headline))

# sift recognizes dplyr group specification.
library(dplyr)
library(mopac)
express \%>\%
 group_by(direction) \%>\%
 sift(time, 30, plate == "EAS-1671") # row augmentation performed within groups.
}
