% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_test_data.R
\name{get_portf_perf}
\alias{get_portf_perf}
\title{Get Portfolio Performance}
\usage{
get_portf_perf(df_scen, stat = "prob_low_prob_ur", fpr = c(0.001, 0.01, 0.05))
}
\arguments{
\item{df_scen}{dataframe as returned by \code{\link{sim_ur_scenarios}}}

\item{stat}{character denoting the column name of the under-reporting
statistic, Default: 'prob_low_prob_ur'}

\item{fpr}{numeric vector specifying false positive rates, Default: c(0.001,
0.01, 0.05)}
}
\value{
dataframe
}
\description{
Performance as true positive rate (tpr as tp/P) on the basis of
desired false positive rates (fpr as fp/P).
}
\details{
DETAILS
}
\examples{
\donttest{
df_visit1 <- sim_test_data_study(n_pat = 100, n_sites = 10,
                                 frac_site_with_ur = 0.4, ur_rate = 0.6)

df_visit1$study_id <- "A"

df_visit2 <- sim_test_data_study(n_pat = 100, n_sites = 10,
                                 frac_site_with_ur = 0.2, ur_rate = 0.1)

df_visit2$study_id <- "B"

df_visit <- dplyr::bind_rows(df_visit1, df_visit2)

df_site_max <- df_visit \%>\%
  dplyr::group_by(study_id, site_number, patnum) \%>\%
  dplyr::summarise(max_visit = max(visit),
                   max_ae = max(n_ae),
                   .groups = "drop")

df_config <- get_config(df_site_max)

df_config

df_portf <- sim_test_data_portfolio(df_config)

df_portf

df_scen <- sim_ur_scenarios(df_portf,
                            extra_ur_sites = 2,
                            ur_rate = c(0.5, 1))


df_scen

df_perf <- get_portf_perf(df_scen)

df_perf
}
}
\seealso{
\code{\link{sim_test_data_study}} \code{\link{get_config}}
\code{\link{sim_test_data_portfolio}} \code{\link{sim_ur_scenarios}}
\code{\link{get_portf_perf}}
}
