% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inframe.R
\name{sim_inframe}
\alias{sim_inframe}
\title{Calculate prob_lower for study sites using table operations}
\usage{
sim_inframe(df_visit, r = 1000, df_site = NULL, event_names = c("ae"))
}
\arguments{
\item{df_visit}{Data frame with columns: study_id, site_number, patnum, visit,
n_ae.}

\item{r}{Integer or tbl_object, number of repetitions for bootstrap
simulation. Pass a tbl object referring to a table with one column and as
many rows as desired repetitions. Default: 1000.}

\item{df_site, }{dataframe as returned be \code{\link[=site_aggr]{site_aggr()}}, Will switch to visit_med75.
Default: NULL}

\item{event_names}{vector, contains the event names, default = "ae"}
}
\description{
Calculate prob_lower for study sites using table operations
}
\examples{
df_visit <- sim_test_data_study(
  n_pat = 100,
  n_sites = 5,
  frac_site_with_ur = 0.4,
  ur_rate = 0.6
)
df_visit$study_id <- "A"

df_sim <- sim_inframe(df_visit)
df_eval <- eval_sites(df_sim)
df_eval
}
