% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex_tree.R
\name{contract}
\alias{contract}
\title{Edge contraction}
\usage{
contract(st, edge)
}
\arguments{
\item{st}{a simplex tree.}

\item{edge}{an edge to contract, as a 2-length vector.}
}
\description{
Performs an edge contraction.
}
\details{
This function performs an \emph{edge contraction} in the sense described by (1), which is 
summarized here. Given an edge \eqn{ {va, vb}}, \eqn{vb} is contracted to \eqn{va} if \eqn{vb} is 
removed from the complex and the link of \eqn{va} is augmented with the link of \eqn{vb}. This may be thought as 
applying the mapping: \cr
\deqn{f(u) = va}
if \eqn{u = vb}
and identity otherwise, to all simplices in the complex. \cr 
\code{edge} is \strong{not} sorted prior to contraction: the second vertex of the edge is always contracted to the first. 
Note that edge contraction is not symmetric.
}
\examples{
st <- simplex_tree(1:3) 
st \%>\% print_simplices()
# 1, 2, 3, 1 2, 1 3, 2 3, 1 2 3
st \%>\% contract(c(1, 3)) \%>\% print_simplices()
# 1, 2, 1 2
}
\references{
1. Boissonnat, Jean-Daniel, and Clement Maria. "The simplex tree: An efficient data structure for general simplicial complexes." Algorithmica 70.3 (2014): 406-427.
}
