% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_qi.R
\name{sim_qi}
\alias{sim_qi}
\title{Get simulations from a model object}
\usage{
sim_qi(
  mod,
  nsim = 1000,
  newdata,
  original_scale = TRUE,
  return_newdata = FALSE
)
}
\arguments{
\item{mod}{a model object}

\item{nsim}{number of simulations to be run, defaults to 1,000}

\item{newdata}{A data frame with a hypothetical prediction grid.
If absent, defaults to the model frame.}

\item{original_scale}{logical, defaults to TRUE. If TRUE, the ensuing
simulations are returned on their original scale. If FALSE, the ensuing
simulations are transformed to a more practical/intuitive quantity that is
potentially more intuitive for the user (e.g. a probability for a logistic
regression). This argument is ignored in the context of
simulations on the linear model.}

\item{return_newdata}{logical, defaults to FALSE. If TRUE, the output returns
additional columns corresponding with the inputs provided to \code{newdata}.
This may facilitate easier transformation along with greater clarity as to
what the simulations correspond.}
}
\value{
\code{sim_qi()} returns a data frame (as a \code{tibble}) with the
quantities of interest and identifying information about the particular
simulation number. For linear models, or simple generalized linear models
where the dependent variable is either "there" or "not there", the quantity
of interest returned is a single column (called \code{y}). For models where the
underlying estimation of the dependent variable is, for lack of a better
term, "multiple" (e.g. ordinal models with the basic proportional odds
assumption), the columns returned correspond with the number of distinct
values of the outcome. For example, an ordinal model where there are five
unique values of the dependent variable will return columns \code{y1}, \code{y2}, \code{y3},
\code{y4}, and \code{y5}.
}
\description{
\code{sim_qi()} is a function to simulate quantities of interest
from a regression model
}
\section{Supported Models}{
\enumerate{
\item Linear models produced by \code{lm()} in base R.
\item Generalized linear models produced by \code{glm()}. Families (links) include:
\itemize{
\item Binomial (logit, probit)
\item Poisson (log)
}
\item Cumulative link models produced by \pkg{ordinal} package.
\itemize{
\item Links: logit, probit
}
}
\subsection{Other Details}{

Specifying a variable in \code{newdata} with the exact same name as the
dependent variable (e.g. \code{mpg} in the simple example provided in this
documentation file) is necessary for matrix multiplication purposes. If you
set \code{return_newdata} to \code{TRUE}, you should not interpret the column matching
the name of the dependent variable as communicating the kind of information
you want from this function. That particular column is just a simple
placeholder you need for matrix multiplication. The information you want will
always be in a column (or columns) named (or starting with) \code{y}.

This function builds in an implicit assumption that your dependent variable
in the regression model is not called \code{y}.

For ordinal models, I recommend setting \code{original_scale} to be FALSE. The
function, underneath the hood, is actually calculating things on the level of
the probability. It's just transforming back to a logit or a probit, if that
is what you say you want.

When \code{original_scale} is \code{TRUE} for Poisson models, the quantity returned is
a logged lambda. When \code{FALSE}, this quantity is exponentiated.
}
}

\examples{

set.seed(8675309)

Data <- mtcars
Data$region <- c("Japan", "Japan", "Japan",
                 "USA", "USA", "USA", "USA",
                 "Europe", "Europe", "Europe", "Europe",
                 "Europe", "Europe", "Europe",
                 "USA", "USA", "USA", "Europe",
                 "Japan", "Japan", "Japan",
                 "USA", "USA", "USA", "USA",
                 "Europe", "Europe", "Europe",
                 "USA", "Europe", "Europe", "Europe")

M1 <- lm(mpg ~ hp + region, Data)

sim_qi(M1, 10)

newdat <- data.frame(mpg = 0, region = c("Europe", "Japan", "USA"), hp = 123)

sim_qi(M1, nsim = 100, newdat, return_newdata = TRUE)

}
