% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst.R
\name{rmst}
\alias{rmst}
\title{RMST difference of 2 arms}
\usage{
rmst(
  data,
  tau = 10,
  var_label_tte = "tte",
  var_label_event = "event",
  var_label_group = "treatment",
  formula = NULL,
  reference = "control",
  alpha = 0.05
)
}
\arguments{
\item{data}{A time-to-event dataset with a column \code{tte} indicating the
survival time and a column of \code{event} indicating whether it is
event or censor.}

\item{tau}{RMST analysis time.}

\item{var_label_tte}{Column name of the TTE variable.}

\item{var_label_event}{Column name of the event variable.}

\item{var_label_group}{Column name of the grouping variable.}

\item{formula}{(default: \code{NULL}) A formula that indicates the TTE, event, and
group variables using the syntax \verb{Surv(tte, event) ~ group)} (see Details
below for more information). This is an alternative to specifying the
variables as strings. If a formula is provided, the values passed to
\code{var_label_tte}, \code{var_label_event}, and \code{var_label_group} are ignored.}

\item{reference}{A group label indicating the reference group.}

\item{alpha}{Type I error.}
}
\value{
The z statistics.
}
\description{
RMST difference of 2 arms
}
\details{
The argument \code{formula} is provided as a convenience to easily specify the
TTE, event, and grouping variables using the syntax \verb{Surv(tte, event) ~ group)}. \code{Surv()} is from the \{survival\} package (\code{\link[survival:Surv]{survival::Surv()}}).
You can also explicitly
name the arguments passed to \code{Surv()}, for example the following is
equivalent \verb{Surv(event = event, time = tte) ~ group)}. Note however that the
function \code{Surv()} is never actually executed. Similarly, any other functions
applied in the formula are also ignored, thus you shouldn't apply any
transformation functions such as \code{log()} since these will have no effect.
}
\examples{
data(ex1_delayed_effect)
rmst(
  data = ex1_delayed_effect,
  var_label_tte = "month",
  var_label_event = "evntd",
  var_label_group = "trt",
  tau = 10,
  reference = "0"
)

# Formula interface
rmst(
  data = ex1_delayed_effect,
  formula = Surv(month, evntd) ~ trt,
  tau = 10,
  reference = "0"
)
}
