% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv_dr}
\alias{deriv_dr}
\title{Analytic D matrix for Drift (DR) Process}
\usage{
deriv_dr(omega, tau)
}
\arguments{
\item{omega}{A \code{double} that is the slope of the drift.}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{matrix} with the first column containing the partial derivative 
with respect to \eqn{\omega}{omega}.
}
\description{
Obtain the first derivative of the Drift (DR) process.
}
\section{Process Haar WV First Derivative}{

Taking the derivative with respect to \eqn{\omega}{omega} yields:
\deqn{\frac{\partial }{{\partial \omega }}\nu _j^2\left( \omega  \right) = \frac{{\tau _j^2\omega }}{8}}{d/domega nu[j]^2 (omega) = (tau[j]^2 * omega)/8}
\strong{Note:} We are taking the derivative with respect to \eqn{\omega}{omega} and not \eqn{\omega^2}{omega^2} as the \eqn{\omega}{omega}
relates to the slope of the process and not the processes variance like RW and WN. As a result, a second derivative exists and is not zero.
}

\author{
James Joseph Balamuta (JJB)
}
