% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning_data.R
\name{limpiar_fecha_event}
\alias{limpiar_fecha_event}
\title{Limpiar fechas de los datos de una enfermedad o evento}
\usage{
limpiar_fecha_event(
  data_event,
  year,
  format_fecha = "\%Y-\%m-\%d",
  col_fecha = "ini_sin",
  col_comp = NULL
)
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de
una enfermedad o evento.}

\item{year}{Un `numeric` (numérico) o `character` (cadena de caracteres)
que contiene el año de los datos de una enfermedad o evento.}

\item{format_fecha}{Un `character` (cadena de caracteres) que contiene
el formato deseado de fecha; su valor por defecto es "\%AAAA-\%MM-\%DD".}

\item{col_fecha}{Un `character` (cadena de caracteres) que contiene
el nombre de la columna con la fecha que se desea limpiar en los datos
de la enfermedad o evento.}

\item{col_comp}{Un `character` (cadena de caracteres) que contiene el
nombre de la columna con la cual se va a comparar la columna `col_fecha`
para limpiarla, estandarizarla o aplicar las reglas definidas.}
}
\value{
Un `data.frame` con las fechas limpias.
}
\description{
Función que limpia y estandariza las fechas de los datos
de una enfermedad o evento.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
limpiar_fecha_event(
  data_event = data_limpia,
  year = 2020,
  format_fecha = "\%Y-\%m-\%d",
  col_fecha = "ini_sin",
  col_comp = "fec_hos"
)
}
