% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig-test.R
\name{nh.Uniform}
\alias{nh.Uniform}
\title{Declination distribution corresponding to a uniform azimuthal
distribution for null hypothesis significance testing}
\usage{
nh.Uniform(loc, alt = 0)
}
\arguments{
\item{loc}{This can be either the latitude of the
location, or a \emph{skyscapeR.horizon} object.}

\item{alt}{(Optional) The horizon altitude to use in
\code{\link{az2dec}} conversion. Defaults to 0 degrees.}
}
\description{
This function returns the declination distribution that
corresponds to a uniform distribution in azimuths (i.e. random
 orientation) for use in significance testing.
}
\examples{
\dontrun{
aux <- nh.Uniform(loc=c(52,-2), alt=2)
plot(aux$dec, aux$density, type='l')
}
}
\seealso{
\code{\link{sigTest}}, \code{\link{nh.SummerFM}}, \code{\link{nh.SolarRange}}
}
