% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adam-ssarima.R, R/autossarima.R, R/ssarima.R
\name{ssarima}
\alias{ssarima}
\alias{auto.ssarima}
\alias{ssarima_old}
\title{State Space ARIMA}
\usage{
ssarima(y, orders = list(ar = c(0), i = c(1), ma = c(1)), lags = c(1),
  constant = FALSE, arma = NULL, model = NULL,
  initial = c("backcasting", "optimal", "two-stage", "complete"),
  loss = c("likelihood", "MSE", "MAE", "HAM", "MSEh", "TMSE", "GTMSE",
  "MSCE"), h = 0, holdout = FALSE, bounds = c("admissible", "usual",
  "none"), silent = TRUE, xreg = NULL, regressors = c("use", "select",
  "adapt"), initialX = NULL, ...)

auto.ssarima(y, orders = list(ar = c(3, 3), i = c(2, 1), ma = c(3, 3)),
  lags = c(1, frequency(y)), fast = TRUE, constant = NULL,
  initial = c("backcasting", "optimal", "two-stage", "complete"),
  loss = c("likelihood", "MSE", "MAE", "HAM", "MSEh", "TMSE", "GTMSE",
  "MSCE"), ic = c("AICc", "AIC", "BIC", "BICc"), h = 0, holdout = FALSE,
  bounds = c("admissible", "usual", "none"), silent = TRUE, xreg = NULL,
  regressors = c("use", "select", "adapt"), ...)

ssarima_old(y, orders = list(ar = c(0), i = c(1), ma = c(1)), lags = c(1),
  constant = FALSE, AR = NULL, MA = NULL, initial = c("backcasting",
  "optimal"), ic = c("AICc", "AIC", "BIC", "BICc"), loss = c("likelihood",
  "MSE", "MAE", "HAM", "MSEh", "TMSE", "GTMSE", "MSCE"), h = 10,
  holdout = FALSE, bounds = c("admissible", "none"), silent = c("all",
  "graph", "legend", "output", "none"), xreg = NULL, regressors = c("use",
  "select"), initialX = NULL, ...)
}
\arguments{
\item{y}{Vector or ts object, containing data needed to be forecasted.}

\item{orders}{List of orders, containing vector variables \code{ar},
\code{i} and \code{ma}. Example:
\code{orders=list(ar=c(1,2),i=c(1),ma=c(1,1,1))}. If a variable is not
provided in the list, then it is assumed to be equal to zero. At least one
variable should have the same length as \code{lags}. Another option is to
specify orders as a vector of a form \code{orders=c(p,d,q)}. The non-seasonal
ARIMA(p,d,q) is constructed in this case.}

\item{lags}{Defines lags for the corresponding orders (see examples above).
The length of \code{lags} must correspond to the length of either \code{ar},
\code{i} or \code{ma} in \code{orders} variable. There is no restrictions on
the length of \code{lags} vector. It is recommended to order \code{lags}
ascending.
The orders are set by a user. If you want the automatic order selection,
then use \link[smooth]{auto.ssarima} function instead.}

\item{constant}{If \code{TRUE}, constant term is included in the model. Can
also be a number (constant value).}

\item{arma}{Either the named list or a vector with AR / MA parameters ordered lag-wise.
The number of elements should correspond to the specified orders e.g.
\code{orders=list(ar=c(1,1),ma=c(1,1)), lags=c(1,4), arma=list(ar=c(0.9,0.8),ma=c(-0.3,0.3))}}

\item{model}{A previously estimated ssarima model, if provided, the function
will not estimate anything and will use all its parameters.}

\item{initial}{Can be either character or a vector of initial states. If it
is character, then it can be \code{"optimal"}, meaning that the initial
states are optimised, or \code{"backcasting"}, meaning that the initials are
produced using backcasting procedure.}

\item{loss}{The type of Loss Function used in optimization. \code{loss} can
be: \code{likelihood} (assuming Normal distribution of error term),
\code{MSE} (Mean Squared Error), \code{MAE} (Mean Absolute Error),
\code{HAM} (Half Absolute Moment), \code{TMSE} - Trace Mean Squared Error,
\code{GTMSE} - Geometric Trace Mean Squared Error, \code{MSEh} - optimisation
using only h-steps ahead error, \code{MSCE} - Mean Squared Cumulative Error.
If \code{loss!="MSE"}, then likelihood and model selection is done based
on equivalent \code{MSE}. Model selection in this cases becomes not optimal.

There are also available analytical approximations for multistep functions:
\code{aMSEh}, \code{aTMSE} and \code{aGTMSE}. These can be useful in cases
of small samples.

Finally, just for fun the absolute and half analogues of multistep estimators
are available: \code{MAEh}, \code{TMAE}, \code{GTMAE}, \code{MACE}, \code{TMAE},
\code{HAMh}, \code{THAM}, \code{GTHAM}, \code{CHAM}.}

\item{h}{Length of forecasting horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{bounds}{What type of bounds to use in the model estimation. The first
letter can be used instead of the whole word. In case of \code{ssarima()}, the
"usual" means restricting AR and MA parameters to lie between -1 and 1.}

\item{silent}{accepts \code{TRUE} and \code{FALSE}. If FALSE, the function
will print its progress and produce a plot at the end.}

\item{xreg}{The vector (either numeric or time series) or the matrix (or
data.frame) of exogenous variables that should be included in the model. If
matrix included than columns should contain variables and rows - observations.
Note that \code{xreg} should have number of observations equal either to
in-sample or to the whole series. If the number of observations in
\code{xreg} is equal to in-sample, then values for the holdout sample are
produced using \link[smooth]{es} function.}

\item{regressors}{The variable defines what to do with the provided xreg:
\code{"use"} means that all of the data should be used, while
\code{"select"} means that a selection using \code{ic} should be done.}

\item{initialX}{The vector of initial parameters for exogenous variables.
Ignored if \code{xreg} is NULL.}

\item{...}{Other non-documented parameters.

Parameter \code{model} can accept a previously estimated SSARIMA model and
use all its parameters.

\code{FI=TRUE} will make the function produce Fisher Information matrix,
which then can be used to calculated variances of parameters of the model.}

\item{fast}{If \code{TRUE}, then some of the orders of ARIMA are
skipped. This is not advised for models with \code{lags} greater than 12.}

\item{ic}{The information criterion used in the model selection procedure.}

\item{AR}{Vector or matrix of AR parameters. The order of parameters should
be lag-wise. This means that first all the AR parameters of the firs lag
should be passed, then for the second etc. AR of another ssarima can be
passed here.}

\item{MA}{Vector or matrix of MA parameters. The order of parameters should
be lag-wise. This means that first all the MA parameters of the firs lag
should be passed, then for the second etc. MA of another ssarima can be
passed here.}
}
\value{
Object of class "adam" is returned with similar elements to the
\link[smooth]{adam} function.

Object of class "smooth" is returned. See \link[smooth]{ssarima} for
details.

Object of class "smooth" is returned. It contains the list of the
following values:

\itemize{
\item \code{model} - the name of the estimated model.
\item \code{timeElapsed} - time elapsed for the construction of the model.
\item \code{states} - the matrix of the fuzzy components of ssarima, where
\code{rows} correspond to time and \code{cols} to states.
\item \code{transition} - matrix F.
\item \code{persistence} - the persistence vector. This is the place, where
smoothing parameters live.
\item \code{measurement} - measurement vector of the model.
\item \code{AR} - the matrix of coefficients of AR terms.
\item \code{I} - the matrix of coefficients of I terms.
\item \code{MA} - the matrix of coefficients of MA terms.
\item \code{constant} - the value of the constant term.
\item \code{initialType} - Type of the initial values used.
\item \code{initial} - the initial values of the state vector (extracted
from \code{states}).
\item \code{nParam} - table with the number of estimated / provided parameters.
If a previous model was reused, then its initials are reused and the number of
provided parameters will take this into account.
\item \code{fitted} - the fitted values.
\item \code{forecast} - the point forecast.
\item \code{lower} - the lower bound of prediction interval. When
\code{interval="none"} then NA is returned.
\item \code{upper} - the higher bound of prediction interval. When
\code{interval="none"} then NA is returned.
\item \code{residuals} - the residuals of the estimated model.
\item \code{errors} - The matrix of 1 to h steps ahead errors. Only returned when the
multistep losses are used and semiparametric interval is needed.
\item \code{s2} - variance of the residuals (taking degrees of freedom into
account).
\item \code{interval} - type of interval asked by user.
\item \code{level} - confidence level for interval.
\item \code{cumulative} - whether the produced forecast was cumulative or not.
\item \code{y} - the original data.
\item \code{holdout} - the holdout part of the original data.
\item \code{xreg} - provided vector or matrix of exogenous variables. If
\code{regressors="s"}, then this value will contain only selected exogenous
variables.
\item \code{initialX} - initial values for parameters of exogenous
variables.
\item \code{ICs} - values of information criteria of the model. Includes
AIC, AICc, BIC and BICc.
\item \code{logLik} - log-likelihood of the function.
\item \code{lossValue} - Cost function value.
\item \code{loss} - Type of loss function used in the estimation.
\item \code{FI} - Fisher Information. Equal to NULL if \code{FI=FALSE}
or when \code{FI} is not provided at all.
\item \code{accuracy} - vector of accuracy measures for the holdout sample.
In case of non-intermittent data includes: MPE, MAPE, SMAPE, MASE, sMAE,
RelMAE, sMSE and Bias coefficient (based on complex numbers). In case of
intermittent data the set of errors will be: sMSE, sPIS, sCE (scaled
cumulative error) and Bias coefficient. This is available only when
\code{holdout=TRUE}.
\item \code{B} - the vector of all the estimated parameters.
}
}
\description{
Function constructs State Space ARIMA, estimating AR, MA terms and initial
states.

Function selects the best State Space ARIMA based on information criteria,
using fancy branch and bound mechanism. The resulting model can be not
optimal in IC meaning, but it is usually reasonable.

Function constructs State Space ARIMA, estimating AR, MA terms and initial
states.
}
\details{
The model, implemented in this function, is discussed in Svetunkov & Boylan
(2019).

The basic ARIMA(p,d,q) used in the function has the following form:

\eqn{(1 - B)^d (1 - a_1 B - a_2 B^2 - ... - a_p B^p) y_[t] = (1 + b_1 B +
b_2 B^2 + ... + b_q B^q) \epsilon_[t] + c}

where \eqn{y_[t]} is the actual values, \eqn{\epsilon_[t]} is the error term,
\eqn{a_i, b_j} are the parameters for AR and MA respectively and \eqn{c} is
the constant. In case of non-zero differences \eqn{c} acts as drift.

This model is then transformed into ARIMA in the Single Source of Error
State space form (proposed in Snyder, 1985):

\eqn{y_{t} = w' v_{t-l} + \epsilon_{t}}

\eqn{v_{t} = F v_{t-l} + g_t \epsilon_{t}}

where \eqn{v_{t}} is the state vector (defined based on
\code{orders}) and \eqn{l} is the vector of \code{lags}, \eqn{w_t} is the
\code{measurement} vector (with explanatory variables if provided), \eqn{F}
is the \code{transition} matrix, \eqn{g_t} is the \code{persistence} vector
(which includes explanatory variables if they were used).

Due to the flexibility of the model, multiple seasonalities can be used. For
example, something crazy like this can be constructed:
SARIMA(1,1,1)(0,1,1)[24](2,0,1)[24*7](0,0,1)[24*30], but the estimation may
take a lot of time... If you plan estimating a model with more than one
seasonality, it is recommended to use \link[smooth]{msarima} instead.

The model selection for SSARIMA is done by the \link[smooth]{auto.ssarima} function.

For some more information about the model and its implementation, see the
vignette: \code{vignette("ssarima","smooth")}

The function constructs bunch of ARIMAs in Single Source of Error
state space form (see \link[smooth]{ssarima} documentation) and selects the
best one based on information criterion. The mechanism is described in
Svetunkov & Boylan (2019).

Due to the flexibility of the model, multiple seasonalities can be used. For
example, something crazy like this can be constructed:
SARIMA(1,1,1)(0,1,1)[24](2,0,1)[24*7](0,0,1)[24*30], but the estimation may
take a lot of time... It is recommended to use \link[smooth]{auto.msarima} in
cases with more than one seasonality and high frequencies.

For some more information about the model and its implementation, see the
vignette: \code{vignette("ssarima","smooth")}

The model, implemented in this function, is discussed in Svetunkov & Boylan
(2019).

The basic ARIMA(p,d,q) used in the function has the following form:

\eqn{(1 - B)^d (1 - a_1 B - a_2 B^2 - ... - a_p B^p) y_[t] = (1 + b_1 B +
b_2 B^2 + ... + b_q B^q) \epsilon_[t] + c}

where \eqn{y_[t]} is the actual values, \eqn{\epsilon_[t]} is the error term,
\eqn{a_i, b_j} are the parameters for AR and MA respectively and \eqn{c} is
the constant. In case of non-zero differences \eqn{c} acts as drift.

This model is then transformed into ARIMA in the Single Source of Error
State space form (proposed in Snyder, 1985):

\eqn{y_{t} = o_{t} (w' v_{t-l} + x_t a_{t-1} + \epsilon_{t})}

\eqn{v_{t} = F v_{t-l} + g \epsilon_{t}}

\eqn{a_{t} = F_{X} a_{t-1} + g_{X} \epsilon_{t} / x_{t}}

Where \eqn{o_{t}} is the Bernoulli distributed random variable (in case of
normal data equal to 1), \eqn{v_{t}} is the state vector (defined based on
\code{orders}) and \eqn{l} is the vector of \code{lags}, \eqn{x_t} is the
vector of exogenous parameters. \eqn{w} is the \code{measurement} vector,
\eqn{F} is the \code{transition} matrix, \eqn{g} is the \code{persistence}
vector, \eqn{a_t} is the vector of parameters for exogenous variables,
\eqn{F_{X}} is the \code{transitionX} matrix and \eqn{g_{X}} is the
\code{persistenceX} matrix.

Due to the flexibility of the model, multiple seasonalities can be used. For
example, something crazy like this can be constructed:
SARIMA(1,1,1)(0,1,1)[24](2,0,1)[24*7](0,0,1)[24*30], but the estimation may
take some finite time... If you plan estimating a model with more than one
seasonality, it is recommended to consider doing it using \link[smooth]{msarima}.

The model selection for SSARIMA is done by the \link[smooth]{auto.ssarima} function.

For some more information about the model and its implementation, see the
vignette: \code{vignette("ssarima","smooth")}
}
\examples{
# ARIMA(1,1,1) fitted to some data
ourModel <- ssarima(rnorm(118,100,3),orders=list(ar=c(1),i=c(1),ma=c(1)),lags=c(1))

# Model with the same lags and orders, applied to a different data
ssarima(rnorm(118,100,3),orders=orders(ourModel),lags=lags(ourModel))

# The same model applied to a different data
ssarima(rnorm(118,100,3),model=ourModel)

# Example of SARIMA(2,0,0)(1,0,0)[4]
\donttest{ssarima(rnorm(118,100,3),orders=list(ar=c(2,1)),lags=c(1,4))}

# SARIMA(1,1,1)(0,0,1)[4] with different initialisations
\donttest{ssarima(rnorm(118,100,3),orders=list(ar=c(1),i=c(1),ma=c(1,1)),
        lags=c(1,4),h=18,holdout=TRUE,initial="backcasting")}


\donttest{set.seed(41)}
\donttest{x <- rnorm(118,100,3)}

# The best ARIMA for the data
\donttest{ourModel <- auto.ssarima(x,orders=list(ar=c(2,1),i=c(1,1),ma=c(2,1)),lags=c(1,12),
                                   h=18,holdout=TRUE)}

# The other one using optimised states
\donttest{auto.ssarima(x,orders=list(ar=c(3,2),i=c(2,1),ma=c(3,2)),lags=c(1,12),
                       initial="two",h=18,holdout=TRUE)}

\donttest{summary(ourModel)
forecast(ourModel)
plot(forecast(ourModel))}


# ARIMA(1,1,1) fitted to some data
ourModel <- ssarima_old(rnorm(118,100,3),orders=list(ar=c(1),i=c(1),ma=c(1)),lags=c(1),h=18,
                             holdout=TRUE)

# Model with the same lags and orders, applied to a different data
ssarima_old(rnorm(118,100,3),orders=orders(ourModel),lags=lags(ourModel),h=18,holdout=TRUE)

# The same model applied to a different data
ssarima_old(rnorm(118,100,3),model=ourModel,h=18,holdout=TRUE)

# SARIMA(0,1,1) with exogenous variables
ssarima_old(rnorm(118,100,3),orders=list(i=1,ma=1),h=18,holdout=TRUE,xreg=c(1:118))

summary(ourModel)
forecast(ourModel)
plot(forecast(ourModel))

}
\references{
\itemize{
\item Svetunkov I. (2023) Smooth forecasting with the smooth package in R. arXiv:2301.01790.
\doi{10.48550/arXiv.2301.01790}.
\item Svetunkov I. (2015 - Inf) "smooth" package for R - series of posts about the underlying
models and how to use them: \url{https://openforecast.org/category/r-en/smooth/}.
}

\itemize{
\item Svetunkov, I., 2023. Smooth Forecasting with the Smooth Package in R. arXiv.
\doi{10.48550/arXiv.2301.01790}
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \doi{10.1007/978-3-540-71918-2}.
}

\itemize{
\item Svetunkov, I., 2023. Smooth Forecasting with the Smooth Package in R. arXiv.
\doi{10.48550/arXiv.2301.01790}
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \doi{10.1007/978-3-540-71918-2}.
}

\itemize{
\item Svetunkov, I., Boylan, J.E., 2023a. iETS: State Space Model for
Intermittent Demand Forecastings. International Journal of Production
Economics. 109013. \doi{10.1016/j.ijpe.2023.109013}
\item Teunter R., Syntetos A., Babai Z. (2011). Intermittent demand:
Linking forecasting to inventory obsolescence. European Journal of
Operational Research, 214, 606-615.
\item Croston, J. (1972) Forecasting and stock control for intermittent
demands. Operational Research Quarterly, 23(3), 289-303.
}

\itemize{
\item Svetunkov, I., & Boylan, J. E. (2019). State-space ARIMA for supply-chain forecasting.
International Journal of Production Research, 0(0), 1–10.
\doi{10.1080/00207543.2019.1600764}
}

\itemize{
\item Svetunkov, I., 2023. Smooth Forecasting with the Smooth Package in R. arXiv.
\doi{10.48550/arXiv.2301.01790}
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \doi{10.1007/978-3-540-71918-2}.
}

\itemize{
\item Svetunkov, I., & Boylan, J. E. (2019). State-space ARIMA for supply-chain forecasting.
International Journal of Production Research, 0(0), 1–10.
\doi{10.1080/00207543.2019.1600764}
}
}
\seealso{
\code{\link[smooth]{auto.ssarima}, \link[smooth]{auto.msarima}, \link[smooth]{adam},
 \link[smooth]{es}, \link[smooth]{ces}}

\code{\link[smooth]{es}, \link[smooth]{ces},
\link[smooth]{sim.es}, \link[smooth]{gum}, \link[smooth]{ssarima}}

\code{\link[smooth]{auto.ssarima}, \link[smooth]{orders},
\link[smooth]{msarima}, \link[smooth]{auto.msarima},
\link[smooth]{sim.ssarima}, \link[smooth]{adam}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
