% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soc_query.R
\name{soc_query}
\alias{soc_query}
\title{Build a Socrata Query Object}
\usage{
soc_query(
  select = NULL,
  where = NULL,
  group_by = NULL,
  having = NULL,
  order_by = NULL,
  limit = NULL
)
}
\arguments{
\item{select}{string; Columns to retrieve.}

\item{where}{string; Filter conditions.}

\item{group_by}{string; Fields to group by.}

\item{having}{string; Conditions to apply to grouped records.}

\item{order_by}{string; Sort order.}

\item{limit}{whole number; The maximum number of records to return.}
}
\value{
An object of class \code{soc_query}, which prints in a readable format and can be used to build query URLs.
}
\description{
Constructs a structured representation of a Socrata Query Language (SOQL) query that can be used with Socrata API endpoints.
This function does not execute the query; it creates an object that can be passed to request functions or printed for inspection.
}
\examples{
query <- soc_query(
  select = "region, avg(magnitude) as avg_magnitude, count(*) as count",
  group_by = "region",
  having = "count >= 5",
  order_by = "avg_magnitude DESC"
)
print(query)

\donttest{
earthquakes_by_region <- soc_read(
  "https://soda.demo.socrata.com/dataset/USGS-Earthquakes-2012-11-08/3wfw-mdbc/",
  query = query
)
}

}
\seealso{
Use this with a function that executes Socrata requests, e.g., \code{soc_read(url, query = soc_query(...))}
}
