structure(list(method = "GET", url = "https://api.us.socrata.com/api/catalog/v1?limit=10&only=dataset&search_context=data.cityofchicago.org&categories=Transportation", 
    status_code = 200L, headers = structure(list(Server = "nginx", 
        Date = "Tue, 22 Jul 2025 20:41:59 GMT", `Content-Type` = "application/json;charset=utf-8", 
        `Transfer-Encoding` = "chunked", Connection = "keep-alive", 
        `Access-Control-Allow-Origin` = "*", Vary = "Accept-Encoding", 
        `Content-Encoding` = "gzip", `X-Socrata-Region` = "aws-us-east-1-fedramp-prod", 
        `Strict-Transport-Security` = "max-age=31536000; includeSubDomains"), class = "httr2_headers"), 
    body = charToRaw("{\n  \"results\" :\n    [\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Traffic Crashes - Crashes\",\n            \"id\" : \"85ca-t3if\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Crash data shows information about each traffic crash on city streets within the City of Chicago limits and under the jurisdiction of Chicago Police Department (CPD). Data are shown as is from the electronic crash reporting system (E-Crash) at CPD, excluding any personally identifiable information. Records are added to the data portal when a crash report is finalized or when amendments are made to an existing report in E-Crash. Data from E-Crash are available for some police districts in 2015, but citywide data are not available until September 2017. About half of all crash reports, mostly minor crashes, are self-reported at the police district by the driver(s) involved and the other half are recorded at the scene by the police officer responding to the crash. Many of the crash parameters, including street condition data, weather condition, and posted speed limits, are recorded by the reporting officer based on best available information at the time, but many of these may disagree with posted information or other assessments on road conditions. If any new or updated information on a crash is received, the reporting officer may amend the crash report at a later time. A traffic crash within the city limits for which CPD is not the responding police agency, typically crashes on interstate highways, freeway ramps, and on local roads along the City boundary, are excluded from this dataset.\\n\\nAll crashes are recorded as per the format specified in the Traffic Crash Report, SR1050, of the Illinois Department of Transportation. The crash data published on the Chicago data portal mostly follows the data elements in SR1050 form. The current version of the SR1050 instructions manual with detailed information on each data elements is available <a href=\\\"https://idot.illinois.gov/Assets/uploads/files/Transportation-System/Manuals-Guides-&-Handbooks/Safety/Illinois Traffic Crash Report SR 1050 Instruction Manual 2019.pdf\\\">here</a>.\\n\\nAs per Illinois statute, only crashes with a property damage value of $1,500 or more or involving bodily injury to any person(s) and that happen on a public roadway and that involve at least one moving vehicle, except bike dooring, are considered reportable crashes. However, CPD records every reported traffic crash event, regardless of the statute of limitations, and hence any formal Chicago crash dataset released by Illinois Department of Transportation may not include all the crashes listed here.\\n\\nChange 11/21/2023: We have removed the RD_NO (Chicago Police Department report number) for privacy reasons.\",\n            \"attribution\" : \"City of Chicago\",\n            \"attribution_link\" : \"http://www.chicago.gov\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T15:44:59.000Z\",\n            \"createdAt\" : \"2017-10-19T22:02:56.000Z\",\n            \"metadata_updated_at\" : \"2023-12-13T16:58:25.000Z\",\n            \"data_updated_at\" : \"2025-07-22T15:44:59.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 4249,\n                \"page_views_last_month\" : 17637,\n                \"page_views_total\" : 659508,\n                \"page_views_last_week_log\" : 12.053247125912428,\n                \"page_views_last_month_log\" : 14.106399360305144,\n                \"page_views_total_log\" : 19.331032821808662\n              },\n            \"columns_name\" :\n              [\n                \"DOORING_I\",\n                \"LOCATION\",\n                \"LONGITUDE\",\n                \"LATITUDE\",\n                \"CRASH_MONTH\",\n                \"CRASH_DAY_OF_WEEK\",\n                \"CRASH_HOUR\",\n                \"INJURIES_UNKNOWN\",\n                \"INJURIES_NO_INDICATION\",\n                \"INJURIES_REPORTED_NOT_EVIDENT\",\n                \"INJURIES_NON_INCAPACITATING\",\n                \"INJURIES_INCAPACITATING\",\n                \"INJURIES_FATAL\",\n                \"INJURIES_TOTAL\",\n                \"MOST_SEVERE_INJURY\",\n                \"NUM_UNITS\",\n                \"WORKERS_PRESENT_I\",\n                \"WORK_ZONE_TYPE\",\n                \"WORK_ZONE_I\",\n                \"STATEMENTS_TAKEN_I\",\n                \"PHOTOS_TAKEN_I\",\n                \"BEAT_OF_OCCURRENCE\",\n                \"STREET_NAME\",\n                \"STREET_DIRECTION\",\n                \"STREET_NO\",\n                \"SEC_CONTRIBUTORY_CAUSE\",\n                \"PRIM_CONTRIBUTORY_CAUSE\",\n                \"DATE_POLICE_NOTIFIED\",\n                \"DAMAGE\",\n                \"HIT_AND_RUN_I\",\n                \"NOT_RIGHT_OF_WAY_I\",\n                \"INTERSECTION_RELATED_I\",\n                \"CRASH_TYPE\",\n                \"REPORT_TYPE\",\n                \"ROAD_DEFECT\",\n                \"ROADWAY_SURFACE_COND\",\n                \"ALIGNMENT\",\n                \"LANE_CNT\",\n                \"TRAFFICWAY_TYPE\",\n                \"FIRST_CRASH_TYPE\",\n                \"LIGHTING_CONDITION\",\n                \"WEATHER_CONDITION\",\n                \"DEVICE_CONDITION\",\n                \"TRAFFIC_CONTROL_DEVICE\",\n                \"POSTED_SPEED_LIMIT\",\n                \"CRASH_DATE\",\n                \"CRASH_DATE_EST_I\",\n                \"CRASH_RECORD_ID\",\n                \"Boundaries - ZIP Codes\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"dooring_i\",\n                \"location\",\n                \"longitude\",\n                \"latitude\",\n                \"crash_month\",\n                \"crash_day_of_week\",\n                \"crash_hour\",\n                \"injuries_unknown\",\n                \"injuries_no_indication\",\n                \"injuries_reported_not_evident\",\n                \"injuries_non_incapacitating\",\n                \"injuries_incapacitating\",\n                \"injuries_fatal\",\n                \"injuries_total\",\n                \"most_severe_injury\",\n                \"num_units\",\n                \"workers_present_i\",\n                \"work_zone_type\",\n                \"work_zone_i\",\n                \"statements_taken_i\",\n                \"photos_taken_i\",\n                \"beat_of_occurrence\",\n                \"street_name\",\n                \"street_direction\",\n                \"street_no\",\n                \"sec_contributory_cause\",\n                \"prim_contributory_cause\",\n                \"date_police_notified\",\n                \"damage\",\n                \"hit_and_run_i\",\n                \"private_property_i\",\n                \"intersection_related_i\",\n                \"crash_type\",\n                \"report_type\",\n                \"road_defect\",\n                \"roadway_surface_cond\",\n                \"alignment\",\n                \"lane_cnt\",\n                \"trafficway_type\",\n                \"first_crash_type\",\n                \"lighting_condition\",\n                \"weather_condition\",\n                \"device_condition\",\n                \"traffic_control_device\",\n                \"posted_speed_limit\",\n                \"crash_date\",\n                \"crash_date_est_i\",\n                \"crash_record_id\",\n                \":@computed_region_rpca_8um6\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Point\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"Whether crash involved a motor vehicle occupant opening a door into the travel path of a bicyclist, causing a crash\",\n                \"The crash location, as determined by reporting officer, as derived from the reported address of crash, in a column type that allows for mapping and other geographic analysis in the data portal software\",\n                \"The longitude of the crash location, as determined by reporting officer, as derived from the reported address of crash\",\n                \"The latitude of the crash location, as determined by reporting officer, as derived from the reported address of crash\",\n                \"The month component of CRASH_DATE.\",\n                \"The day of the week component of CRASH_DATE. Sunday=1\\n\\n\",\n                \"The hour of the day component of CRASH_DATE.\",\n                \"Total persons for whom injuries sustained, if any, are unknown\",\n                \"Total persons sustaining no injuries in the crash as determined by the reporting officer\",\n                \"Total persons sustaining possible injuries in the crash as determined by the reporting officer. Includes momentary unconsciousness, claims of injuries not evident, limping, complaint of pain, nausea, and hysteria.\",\n                \"Total persons sustaining non-incapacitating injuries in the crash as determined by the reporting officer. Any injury, other than fatal or incapacitating injury, which is evident to observers at the scene of the crash. Includes lump on head, abrasions, bruises, and minor lacerations.\",\n                \"Total persons sustaining incapacitating/serious injuries in the crash as determined by the reporting officer. Any injury other than fatal injury, which prevents the injured person from walking, driving, or normally continuing the activities they were capable of performing before the injury occurred. Includes severe lacerations, broken limbs, skull or chest injuries, and abdominal injuries.\",\n                \"Total persons sustaining fatal injuries in the crash\",\n                \"Total persons sustaining fatal, incapacitating, non-incapacitating, and possible injuries as determined by the reporting officer\",\n                \"Most severe injury sustained by any person involved in the crash\",\n                \"Number of units involved in the crash. A unit can be a motor vehicle, a pedestrian, a bicyclist, or another non-passenger roadway user. Each unit represents a mode of traffic with an independent trajectory. \",\n                \"Whether construction workers were present in an active work zone at crash location\",\n                \"The type of work zone, if any\",\n                \"Whether the crash occurred in an active work zone\",\n                \"Whether statements were taken from unit(s) involved in crash\",\n                \"Whether the Chicago Police Department took photos at the location of the crash\",\n                \"Chicago Police Department Beat ID. Boundaries available at https://data.cityofchicago.org/d/aerh-rz74\",\n                \"Street address name of crash location, as determined by reporting officer\",\n                \"Street address direction (N,E,S,W) of crash location, as determined by reporting officer\",\n                \"Street address number of crash location, as determined by reporting officer\",\n                \"The factor which was second most significant in causing the crash, as determined by officer judgment\",\n                \"The factor which was most significant in causing the crash, as determined by officer judgment\",\n                \"Calendar date on which police were notified of the crash\",\n                \"A field observation of estimated damage.\",\n                \"Crash did/did not involve a driver who caused the crash and fled the scene without exchanging information and/or rendering aid\",\n                \"Whether the crash begun or first contact was made outside of the public right-of-way.\",\n                \"A field observation by the police officer whether an intersection played a role in the crash. Does not represent whether or not the crash occurred within the intersection.\",\n                \"A general severity classification for the crash. Can be either Injury and/or Tow Due to Crash or No Injury / Drive Away \",\n                \"Administrative report type (at scene, at desk, amended)\",\n                \"Road defects, as determined by reporting officer\",\n                \"Road surface condition, as determined by reporting officer\",\n                \"Street alignment at crash location, as determined by reporting officer\",\n                \"Total number of through lanes in either direction, excluding turn lanes, as determined by reporting officer (0 = intersection)\",\n                \"Trafficway type, as determined by reporting officer\",\n                \"Type of first collision in crash\",\n                \"Light condition at time of crash, as determined by reporting officer\",\n                \"Weather condition at time of crash, as determined by reporting officer\",\n                \"Condition of traffic control device, as determined by reporting officer\",\n                \"Traffic control device present at crash location, as determined by reporting officer\",\n                \"Posted speed limit, as determined by reporting officer\",\n                \"Date and time of crash as entered by the reporting officer\",\n                \"Crash date estimated by desk officer or reporting party (only used in cases where crash is reported at police station days after the crash)\",\n                \"This number can be used to link to the same crash in the Vehicles and People datasets. This number also serves as a unique ID in this dataset.\",\n                \"This column was automatically created in order to record in what polygon from the dataset 'Boundaries - ZIP Codes' (rpca-8um6) the point in column 'location' is located.  This enables the creation of region maps (choropleths) in the visualization canvas and data lens.\"\n              ],\n            \"columns_format\" :\n              [\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"decimalSeparator\" : \".\",\n                  \"groupSeparator\" : \",\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"decimalSeparator\" : \".\",\n                  \"groupSeparator\" : \",\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"precision\" : \"0\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"left\" },\n                { \"precisionStyle\" : \"standard\", \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"view\" : \"date_time\", \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"precisionStyle\" : \"standard\", \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"precisionStyle\" : \"standard\", \"align\" : \"right\" },\n                { \"view\" : \"date_time\", \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {},\n                {}\n              ],\n            \"download_count\" : 44173,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2023-07-27T20:59:32.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"transportation\", \"health\", \"public safety\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [\n                \"link to article present\",\n                \"public safety\",\n                \"traffic crashes\",\n                \"transportation\",\n                \"vision zero\"\n              ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Metadata_Frequency\", \"value\" : \"Daily\" },\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Police Department\"\n                },\n                {\n                  \"key\" : \"Metadata_Time-Period\",\n                  \"value\" : \"2015 to present (All police districts September 2017 - present)\"\n                },\n                {\n                  \"key\" : \"Metadata_Changes-and-Other-Historical-Information-Useful-to-Understanding-This-Dataset\",\n                  \"value\" : \"http://dev.cityofchicago.org/open%20data/data%20portal/2020/07/21/traffic-crash-data-source.html | http://dev.cityofchicago.org/open%20data/data%20portal/2020/02/11/traffic-crash-rd-numbers.html\"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.cityofchicago.org\",\n            \"license\" : \"See Terms of Use\"\n          },\n        \"permalink\" : \"https://data.cityofchicago.org/d/85ca-t3if\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/Traffic-Crashes-Crashes/85ca-t3if\",\n        \"owner\" :\n          {\n            \"id\" : \"vewm-vupz\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Jonathan Levy\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"vewm-vupz\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Jonathan Levy\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Chicago Street Names\",\n            \"id\" : \"i6bp-fvbx\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"List of all Chicago streets with suffixes and minimum and maximum address numbers.\",\n            \"attribution\" : \"City of Chicago\",\n            \"attribution_link\" : \"http://www.cityofchicago.org\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2012-05-30T22:29:43.000Z\",\n            \"createdAt\" : \"2010-12-22T01:42:52.000Z\",\n            \"metadata_updated_at\" : \"2012-05-30T22:29:43.000Z\",\n            \"data_updated_at\" : \"2012-05-30T22:29:40.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 376,\n                \"page_views_last_month\" : 1497,\n                \"page_views_total\" : 356540,\n                \"page_views_last_week_log\" : 8.558420713268665,\n                \"page_views_last_month_log\" : 10.548821908458752,\n                \"page_views_total_log\" : 18.443708461612502\n              },\n            \"columns_name\" :\n              [\n                \"Suffix Direction\",\n                \"Street \",\n                \"Full Street Name\",\n                \"Suffix\",\n                \"Min Address\",\n                \"Max Address\",\n                \"Direction\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"suffix_direction\",\n                \"street\",\n                \"full_street_name\",\n                \"suffix\",\n                \"min_address\",\n                \"max_address\",\n                \"direction\"\n              ],\n            \"columns_datatype\" :\n              [ \"Text\", \"Text\", \"Text\", \"Text\", \"Number\", \"Number\", \"Text\" ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                { \"align\" : \"left\", \"aggregate\" : \"count\" },\n                { \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                {}\n              ],\n            \"download_count\" : 20336,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2012-05-30T22:29:43.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"gis\", \"streets\" ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Metadata_Frequency\", \"value\" : \"\" },\n                { \"key\" : \"Metadata_Data-Owner\", \"value\" : \"\" },\n                { \"key\" : \"Metadata_Time-Period\", \"value\" : \"\" }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/i6bp-fvbx\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/Chicago-Street-Names/i6bp-fvbx\",\n        \"owner\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Towed Vehicles\",\n            \"id\" : \"ygr5-vcbg\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset displays location for vehicles that have been towed and impounded by the City of Chicago within the last 90 days. Illegally parked vehicles, abandoned vehicles and vehicles used for illegal activities may be towed by the Chicago Police Department, the Department of Streets and Sanitation, the Department of Revenue, Aviation and the office of the City Clerk. After a tow request is issued, an inventory number is assigned by the Department of Streets and Sanitation and a truck is dispatched to tow the requested vehicle to a City auto pound. Disclaimer: This dataset includes vehicles towed or relocated by the City of Chicago; it does not include vehicles towed by a private towing company. \\r\\n\\r\\nBackground Information: \\r\\nAuto Pound Locations (http://j.mp/kG5sgF).\\r\\nTow Process Overview (http://j.mp/lfBOEP).\\r\\nCommon Towing Questions (http://j.mp/imFYlp).\\r\\nParking and Standing Violations (http://j.mp/ifW8Uj).\\r\\nRelated Applications: Find Your Vehicle (http://j.mp/lWn0S7).\",\n            \"attribution\" : \"Chicago Police Department\",\n            \"attribution_link\" : \"http://www.chicagopolice.org/\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T20:17:25.000Z\",\n            \"createdAt\" : \"2011-09-30T08:00:05.000Z\",\n            \"metadata_updated_at\" : \"2017-10-12T15:23:55.000Z\",\n            \"data_updated_at\" : \"2025-07-22T20:17:25.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 238,\n                \"page_views_last_month\" : 1209,\n                \"page_views_total\" : 160674,\n                \"page_views_last_week_log\" : 7.90086680798075,\n                \"page_views_last_month_log\" : 10.240791332161956,\n                \"page_views_total_log\" : 17.293785946811344\n              },\n            \"columns_name\" :\n              [\n                \"Color\",\n                \"Tow Facility Phone\",\n                \"Model\",\n                \"Style\",\n                \"Towed to Address\",\n                \"State\",\n                \"Inventory Number\",\n                \"Plate\",\n                \"Tow Date\",\n                \"Make\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"color\",\n                \"tow_facility_phone\",\n                \"model\",\n                \"style\",\n                \"towed_to_address\",\n                \"state\",\n                \"inventory_number\",\n                \"plate\",\n                \"tow_date\",\n                \"make\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\"\n              ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                {},\n                { \"view\" : \"date\", \"align\" : \"left\", \"aggregate\" : \"count\" },\n                {}\n              ],\n            \"download_count\" : 26929,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2014-12-01T15:17:41.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"public safety\", \"economy\", \"transportation\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"streets\", \"towing\", \"vehicles\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Frequency\",\n                  \"value\" : \"Data are updated multiple times per hour\"\n                },\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Police Department\"\n                },\n                { \"key\" : \"Metadata_Time-Period\", \"value\" : \"Last 90 days\" }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/ygr5-vcbg\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/Towed-Vehicles/ygr5-vcbg\",\n        \"owner\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Traffic Crashes - Vehicles\",\n            \"id\" : \"68nd-jvt3\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset contains information about vehicles (or units as they are identified in crash reports) involved in a traffic crash. This dataset should be used in conjunction with the traffic Crash and People dataset available in the portal. “Vehicle” information includes motor vehicle and non-motor vehicle modes of transportation, such as bicycles and pedestrians. Each mode of transportation involved in a crash is a “unit” and get one entry here. Each vehicle, each pedestrian, each motorcyclist, and each bicyclist is considered an independent unit that can have a trajectory separate from the other units. However, people inside a vehicle including the driver do not have a trajectory separate from the vehicle in which they are travelling and hence only the vehicle they are travelling in get any entry here. This type of identification of “units” is needed to determine how each movement affected the crash. Data for occupants who do not make up an independent unit, typically drivers and passengers, are available in the People table. Many of the fields are coded to denote the type and location of damage on the vehicle. Vehicle information can be linked back to Crash data using the “CRASH_RECORD_ID” field. Since this dataset is a combination of vehicles, pedestrians, and pedal cyclists not all columns are applicable to each record. Look at the Unit Type field to determine what additional data may be available for that record.\\n\\nThe Chicago Police Department reports crashes on IL Traffic Crash Reporting form SR1050. The crash data published on the Chicago data portal mostly follows the data elements in SR1050 form. The current version of the SR1050 instructions manual with detailed information on each data elements is available <a href=\\\"https://idot.illinois.gov/Assets/uploads/files/Transportation-System/Manuals-Guides-&-Handbooks/Safety/Illinois Traffic Crash Report SR 1050 Instruction Manual 2019.pdf\\\">here</a>.\\n\\nChange 11/21/2023: We have removed the RD_NO (Chicago Police Department report number) for privacy reasons.\",\n            \"attribution\" : \"City of Chicago\",\n            \"attribution_link\" : \"http://www.chicago.gov\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T15:11:46.000Z\",\n            \"createdAt\" : \"2018-01-04T23:24:43.000Z\",\n            \"metadata_updated_at\" : \"2024-08-02T21:12:34.000Z\",\n            \"data_updated_at\" : \"2025-07-22T15:11:46.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 663,\n                \"page_views_last_month\" : 2901,\n                \"page_views_total\" : 100979,\n                \"page_views_last_week_log\" : 9.375039431346925,\n                \"page_views_last_month_log\" : 11.502831804066744,\n                \"page_views_total_log\" : 16.623710056938467\n              },\n            \"columns_name\" :\n              [\n                \"GVWR\",\n                \"VEHICLE_YEAR\",\n                \"LIC_PLATE_STATE\",\n                \"WIDE_LOAD_I\",\n                \"VEHICLE_ID\",\n                \"AREA_99_I\",\n                \"HAZMAT_CLASS\",\n                \"AREA_09_I\",\n                \"CARRIER_NAME\",\n                \"MANEUVER\",\n                \"VEHICLE_CONFIG\",\n                \"AREA_03_I\",\n                \"HAZMAT_PLACARDS_I\",\n                \"TRAVEL_DIRECTION\",\n                \"AREA_01_I\",\n                \"AREA_05_I\",\n                \"COMMERCIAL_SRC\",\n                \"LOAD_TYPE\",\n                \"USDOT_NO\",\n                \"TRAILER1_WIDTH\",\n                \"MCS_VIO_CAUSE_CRASH_I\",\n                \"CRASH_DATE\",\n                \"CARGO_BODY_TYPE\",\n                \"CRASH_RECORD_ID\",\n                \"MCS_REPORT_NO\",\n                \"HAZMAT_REPORT_NO\",\n                \"AREA_07_I\",\n                \"FIRE_I\",\n                \"CCMC_NO\",\n                \"MCS_REPORT_I\",\n                \"TRAILER1_LENGTH\",\n                \"TOTAL_VEHICLE_LENGTH\",\n                \"HAZMAT_PRESENT_I\",\n                \"CRASH_UNIT_ID\",\n                \"AREA_06_I\",\n                \"AREA_11_I\",\n                \"AXLE_CNT\",\n                \"TRAILER2_LENGTH\",\n                \"TOWED_I\",\n                \"OCCUPANT_CNT\",\n                \"MCS_OUT_OF_SERVICE_I\",\n                \"UNIT_NO\",\n                \"TOWED_BY\",\n                \"HAZMAT_VIO_CAUSE_CRASH_I\",\n                \"AREA_12_I\",\n                \"UNIT_TYPE\",\n                \"VEHICLE_TYPE\",\n                \"AREA_02_I\",\n                \"TOWED_TO\",\n                \"AREA_00_I\",\n                \"VEHICLE_DEFECT\",\n                \"UN_NO\",\n                \"IDOT_PERMIT_NO\",\n                \"EXCEED_SPEED_LIMIT_I\",\n                \"NUM_PASSENGERS\",\n                \"CARRIER_STATE\",\n                \"AREA_08_I\",\n                \"TRAILER2_WIDTH\",\n                \"ILCC_NO\",\n                \"HAZMAT_OUT_OF_SERVICE_I\",\n                \"CMRC_VEH_I\",\n                \"CARRIER_CITY\",\n                \"HAZMAT_NAME\",\n                \"VEHICLE_USE\",\n                \"HAZMAT_REPORT_I\",\n                \"AREA_04_I\",\n                \"CMV_ID\",\n                \"FIRST_CONTACT_POINT\",\n                \"AREA_10_I\",\n                \"MAKE\",\n                \"MODEL\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"gvwr\",\n                \"vehicle_year\",\n                \"lic_plate_state\",\n                \"wide_load_i\",\n                \"vehicle_id\",\n                \"area_99_i\",\n                \"hazmat_class\",\n                \"area_09_i\",\n                \"carrier_name\",\n                \"maneuver\",\n                \"vehicle_config\",\n                \"area_03_i\",\n                \"hazmat_placards_i\",\n                \"travel_direction\",\n                \"area_01_i\",\n                \"area_05_i\",\n                \"commercial_src\",\n                \"load_type\",\n                \"usdot_no\",\n                \"trailer1_width\",\n                \"mcs_vio_cause_crash_i\",\n                \"crash_date\",\n                \"cargo_body_type\",\n                \"crash_record_id\",\n                \"mcs_report_no\",\n                \"hazmat_report_no\",\n                \"area_07_i\",\n                \"fire_i\",\n                \"ccmc_no\",\n                \"mcs_report_i\",\n                \"trailer1_length\",\n                \"total_vehicle_length\",\n                \"hazmat_present_i\",\n                \"crash_unit_id\",\n                \"area_06_i\",\n                \"area_11_i\",\n                \"axle_cnt\",\n                \"trailer2_length\",\n                \"towed_i\",\n                \"occupant_cnt\",\n                \"mcs_out_of_service_i\",\n                \"unit_no\",\n                \"towed_by\",\n                \"hazmat_vio_cause_crash_i\",\n                \"area_12_i\",\n                \"unit_type\",\n                \"vehicle_type\",\n                \"area_02_i\",\n                \"towed_to\",\n                \"area_00_i\",\n                \"vehicle_defect\",\n                \"un_no\",\n                \"idot_permit_no\",\n                \"exceed_speed_limit_i\",\n                \"num_passengers\",\n                \"carrier_state\",\n                \"area_08_i\",\n                \"trailer2_width\",\n                \"ilcc_no\",\n                \"hazmat_out_of_service_i\",\n                \"cmrc_veh_i\",\n                \"carrier_city\",\n                \"hazmat_name\",\n                \"vehicle_use\",\n                \"hazmat_report_i\",\n                \"area_04_i\",\n                \"cmv_id\",\n                \"first_contact_point\",\n                \"area_10_i\",\n                \"make\",\n                \"model\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"\",\n                \"The model year of the vehicle, if relevant\",\n                \"The state issuing the license plate of the vehicle, if relevant\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"The action the unit was taking prior to the crash, as determined by the reporting officer\",\n                \"\",\n                \"\",\n                \"\",\n                \"The direction in which the unit was traveling prior to the crash, as determined by the reporting officer\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"Date and time of crash as entered by the reporting officer\",\n                \"\",\n                \"This number can be used to link to the same crash in the Crashes and People datasets. This number also serves as a unique ID in the Crashes dataset.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"A unique identifier for each vehicle record.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"Indicator of whether the vehicle was towed\",\n                \"The number of people in the unit, as determined by the reporting officer\",\n                \"\",\n                \"A unique ID for each unit within a specific crash report.\",\n                \"Entity that towed the unit, if relevant\",\n                \"\",\n                \"\",\n                \"The type of unit\",\n                \"The type of vehicle, if relevant\",\n                \"\",\n                \"Location to which the unit was towed, if relevant\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"Indicator of whether the unit was speeding, as determined by the reporting officer\",\n                \"Number of passengers in the vehicle. The driver is not included. More information on passengers is in the People dataset.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"The normal use of the vehicle, if relevant\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"The make (brand) of the vehicle, if relevant\",\n                \"The model of the vehicle, if relevant\"\n              ],\n            \"columns_format\" :\n              [\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"view\" : \"date_time\", \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                {},\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"decimalSeparator\" : \".\",\n                  \"groupSeparator\" : \",\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"decimalSeparator\" : \".\",\n                  \"groupSeparator\" : \",\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"decimalSeparator\" : \".\",\n                  \"groupSeparator\" : \",\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"decimalSeparator\" : \".\",\n                  \"groupSeparator\" : \",\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"decimalSeparator\" : \".\",\n                  \"groupSeparator\" : \",\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"decimalSeparator\" : \".\",\n                  \"groupSeparator\" : \",\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"precisionStyle\" : \"standard\", \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"right\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"decimalSeparator\" : \".\",\n                  \"groupSeparator\" : \",\",\n                  \"align\" : \"right\"\n                },\n                { \"align\" : \"left\" },\n                { \"align\" : \"right\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" }\n              ],\n            \"download_count\" : 11053,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2020-02-11T22:14:19.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [\n                \"link to article present\",\n                \"public safety\",\n                \"traffic crashes\",\n                \"transportation\",\n                \"vision zero\"\n              ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Metadata_Frequency\", \"value\" : \"Daily\" },\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Police Department\"\n                },\n                {\n                  \"key\" : \"Metadata_Time-Period\",\n                  \"value\" : \"2015 to present (All police districts September 2017 - present)\"\n                },\n                {\n                  \"key\" : \"Metadata_Changes-and-Other-Historical-Information-Useful-to-Understanding-This-Dataset\",\n                  \"value\" : \"http://dev.cityofchicago.org/open%20data/data%20portal/2020/07/21/traffic-crash-data-source.html | http://dev.cityofchicago.org/open%20data/data%20portal/2020/02/11/traffic-crash-rd-numbers.html\"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.cityofchicago.org\",\n            \"license\" : \"See Terms of Use\"\n          },\n        \"permalink\" : \"https://data.cityofchicago.org/d/68nd-jvt3\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/Traffic-Crashes-Vehicles/68nd-jvt3\",\n        \"owner\" :\n          {\n            \"id\" : \"vewm-vupz\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Jonathan Levy\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"vewm-vupz\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Jonathan Levy\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Transportation Network Providers - Trips (2018 - 2022)\",\n            \"id\" : \"m6dm-c72p\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"<b>This dataset ends with 2022. Please see the Featured Content link below for the dataset that starts in 2023.</b>\\r\\n\\r\\nAll trips, from November 2018 to December 2022, reported by Transportation Network Providers (sometimes called rideshare companies) to the City of Chicago as part of routine reporting required by ordinance.\\r\\n\\r\\nCensus Tracts are suppressed in some cases, and times are rounded to the nearest 15 minutes. Fares are rounded to the nearest $2.50 and tips are rounded to the nearest $1.00.\\r\\n\\r\\nFor a discussion of the approach to privacy in this dataset, please see https://data.cityofchicago.org/stories/s/82d7-i4i2.\",\n            \"attribution\" : \"City of Chicago\",\n            \"attribution_link\" : \"https://www.chicago.gov\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-02-27T22:25:47.000Z\",\n            \"createdAt\" : \"2018-10-02T15:31:29.000Z\",\n            \"metadata_updated_at\" : \"2025-02-27T22:25:47.000Z\",\n            \"data_updated_at\" : \"2023-03-29T22:57:23.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 167,\n                \"page_views_last_month\" : 805,\n                \"page_views_total\" : 92378,\n                \"page_views_last_week_log\" : 7.392317422778761,\n                \"page_views_last_month_log\" : 9.654636028527968,\n                \"page_views_total_log\" : 16.495277308688884\n              },\n            \"columns_name\" :\n              [\n                \"Pickup Census Tract\",\n                \"Pickup Centroid Location\",\n                \"Trip Miles\",\n                \"Trip End Timestamp\",\n                \"Pickup Community Area\",\n                \"Additional Charges\",\n                \"Trip Total\",\n                \"Trip Seconds\",\n                \"Dropoff Community Area\",\n                \"Trip ID\",\n                \"Trips Pooled\",\n                \"Dropoff Centroid Location\",\n                \"Dropoff Centroid Longitude\",\n                \"Pickup Centroid Longitude\",\n                \"Fare\",\n                \"Shared Trip Authorized\",\n                \"Trip Start Timestamp\",\n                \"Tip\",\n                \"Pickup Centroid Latitude\",\n                \"Dropoff Census Tract\",\n                \"Dropoff Centroid Latitude\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"pickup_census_tract\",\n                \"pickup_centroid_location\",\n                \"trip_miles\",\n                \"trip_end_timestamp\",\n                \"pickup_community_area\",\n                \"additional_charges\",\n                \"trip_total\",\n                \"trip_seconds\",\n                \"dropoff_community_area\",\n                \"trip_id\",\n                \"trips_pooled\",\n                \"dropoff_centroid_location\",\n                \"dropoff_centroid_longitude\",\n                \"pickup_centroid_longitude\",\n                \"fare\",\n                \"shared_trip_authorized\",\n                \"trip_start_timestamp\",\n                \"tip\",\n                \"pickup_centroid_latitude\",\n                \"dropoff_census_tract\",\n                \"dropoff_centroid_latitude\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Point\",\n                \"Number\",\n                \"Calendar date\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Point\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Checkbox\",\n                \"Calendar date\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"The Census Tract where the trip began.This column often will be blank for locations outside Chicago.\",\n                \"The location of the center of the pickup census tract or the community area if the census tract has been hidden for privacy. This column often will be blank for locations outside Chicago.\",\n                \"Distance of the trip in miles.\",\n                \"When the trip ended, rounded to the nearest 15 minutes.\",\n                \"The Community Area where the trip began. This column will be blank for locations outside Chicago.\",\n                \"The taxes, fees, and any other charges for the trip.\",\n                \"Total cost of the trip. This is calculated as the total of the previous columns, including rounding.\",\n                \"Time of the trip in seconds.\",\n                \"The Community Area where the trip ended. This column will be blank for locations outside Chicago.\",\n                \"A unique identifier for the trip.\",\n                \"If customers were matched for a shared trip, how many trips, including this one, were pooled. All customer trips from the time the vehicle was empty until it was empty again contribute to this count, even if some customers were never present in the vehicle at the same time. Each trip making up the overall shared trip will have a separate record in this dataset, with the same value in this column.\",\n                \"The location of the center of the dropoff census tract or the community area if the census tract has been hidden for privacy. This column often will be blank for locations outside Chicago.\",\n                \"The longitude of the center of the dropoff census tract or the community area if the census tract has been hidden for privacy. This column often will be blank for locations outside Chicago.\",\n                \"The longitude of the center of the pickup census tract or the community area if the census tract has been hidden for privacy. This column often will be blank for locations outside Chicago.\",\n                \"The fare for the trip, rounded to the nearest $2.50.\",\n                \"Whether the customer agreed to a shared trip with another customer, regardless of whether the customer was actually matched for a shared trip.\",\n                \"When the trip started, rounded to the nearest 15 minutes.\",\n                \"The tip for the trip, rounded to the nearest $1.00. Cash tips will not be recorded.\",\n                \"The latitude of the center of the pickup census tract or the community area if the census tract has been hidden for privacy. This column often will be blank for locations outside Chicago.\",\n                \"The Census Tract where the trip ended. This column often will be blank for locations outside Chicago.\",\n                \"The latitude of the center of the dropoff census tract or the community area if the census tract has been hidden for privacy. This column often will be blank for locations outside Chicago.\"\n              ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                { \"precision\" : \"1\" },\n                { \"view\" : \"date_time\" },\n                {},\n                { \"precisionStyle\" : \"currency\" },\n                { \"precisionStyle\" : \"currency\" },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                { \"precisionStyle\" : \"currency\" },\n                {},\n                { \"view\" : \"date_time\" },\n                { \"precisionStyle\" : \"currency\" },\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 21197,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2019-03-13T21:48:46.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [\n                \"2018\",\n                \"2019\",\n                \"2020\",\n                \"2021\",\n                \"2022\",\n                \"historical\",\n                \"rideshare\",\n                \"tnp\",\n                \"transportation\",\n                \"transportation network provider\",\n                \"trips\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Department of Business Affairs & Consumer Protection\"\n                },\n                {\n                  \"key\" : \"Metadata_Time-Period\",\n                  \"value\" : \"November 2018 to December 2022\"\n                },\n                {\n                  \"key\" : \"Metadata_Changes-and-Other-Historical-Information-Useful-to-Understanding-This-Dataset\",\n                  \"value\" : \"https://www.google.com/search?as_q=\\\"Related+dataset+ID+s\\\"+\\\"m6dm-c72p\\\"+inurl:stories&as_sitesearch=data.cityofchicago.org\"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.cityofchicago.org\",\n            \"license\" : \"See Terms of Use\"\n          },\n        \"permalink\" : \"https://data.cityofchicago.org/d/m6dm-c72p\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/Transportation-Network-Providers-Trips-2018-2022-/m6dm-c72p\",\n        \"owner\" :\n          {\n            \"id\" : \"vewm-vupz\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Jonathan Levy\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"vewm-vupz\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Jonathan Levy\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - Ridership - Daily Boarding Totals\",\n            \"id\" : \"6iiy-9s97\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset shows systemwide boardings for both bus and rail services provided by CTA, dating back to 2001. Daytypes are as follows: W = Weekday, A = Saturday, U = Sunday/Holiday. See attached readme file for information on how these numbers are calculated.\",\n            \"attribution\" : \"Chicago Transit Authority\",\n            \"attribution_link\" : \"http://www.transitchicago.com\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-06-30T18:44:33.000Z\",\n            \"createdAt\" : \"2011-08-12T15:40:31.000Z\",\n            \"metadata_updated_at\" : \"2025-06-30T18:44:32.000Z\",\n            \"data_updated_at\" : \"2025-06-30T18:44:33.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 441,\n                \"page_views_last_month\" : 2131,\n                \"page_views_total\" : 108062,\n                \"page_views_last_week_log\" : 8.787902559391432,\n                \"page_views_last_month_log\" : 11.057991722759176,\n                \"page_views_total_log\" : 16.721513113569625\n              },\n            \"columns_name\" :\n              [\n                \"total_rides\",\n                \"bus\",\n                \"service_date\",\n                \"day_type\",\n                \"rail_boardings\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"total_rides\",\n                \"bus\",\n                \"service_date\",\n                \"day_type\",\n                \"rail_boardings\"\n              ],\n            \"columns_datatype\" :\n              [ \"Number\", \"Number\", \"Calendar date\", \"Text\", \"Number\" ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                { \"view\" : \"date\", \"align\" : \"left\", \"aggregate\" : \"count\" },\n                {},\n                {}\n              ],\n            \"download_count\" : 38841,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2025-04-29T16:35:04.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"cta\", \"public transit\", \"ridership\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority \"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.cityofchicago.org\",\n            \"license\" : \"See Terms of Use\"\n          },\n        \"permalink\" : \"https://data.cityofchicago.org/d/6iiy-9s97\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-Ridership-Daily-Boarding-Totals/6iiy-9s97\",\n        \"owner\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Speed Camera Locations\",\n            \"id\" : \"4i42-qv3h\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset shows the location, first operational date, and approaches of the speed cameras in the City of Chicago. The approach describes the originating direction of travel which is monitored by a speed camera.\\n\\nTo attempt to make historical versions of this dataset more available, \\\"Dataset Changelog\\\" is enabled at the bottom of the main page. We cannot guarantee that the archival records will remain permanently so advise downloading any you think you may want. Some intermediate versions, especially minor changes, may not be visible. The map based on this dataset will not have past versions.\",\n            \"attribution\" : \"City of Chicago\",\n            \"attribution_link\" : \"http://www.cityofchicago.org\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-15T10:12:15.000Z\",\n            \"createdAt\" : \"2014-08-11T15:35:01.000Z\",\n            \"metadata_updated_at\" : \"2023-08-17T17:22:45.000Z\",\n            \"data_updated_at\" : \"2025-07-15T10:12:15.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 112,\n                \"page_views_last_month\" : 557,\n                \"page_views_total\" : 67747,\n                \"page_views_last_week_log\" : 6.820178962415189,\n                \"page_views_last_month_log\" : 9.124121311829187,\n                \"page_views_total_log\" : 16.047890736603836\n              },\n            \"columns_name\" :\n              [\n                \"LOCATION\",\n                \"LOCATION ID\",\n                \"LOCATION (state)\",\n                \"LONGITUDE\",\n                \"LOCATION (city)\",\n                \"ADDRESS\",\n                \"ID\",\n                \"GO-LIVE DATE\",\n                \"LATITUDE\",\n                \"FIRST APPROACH\",\n                \"Historical Wards 2003-2015\",\n                \"Zip Codes\",\n                \"Community Areas\",\n                \"Census Tracts\",\n                \"Wards\",\n                \"SECOND APPROACH\",\n                \"LOCATION (address)\",\n                \"LOCATION (zip)\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"location\",\n                \"location_id\",\n                \"location_state\",\n                \"longitude\",\n                \"location_city\",\n                \"address\",\n                \"id\",\n                \"go_live_date\",\n                \"latitude\",\n                \"first_approach\",\n                \":@computed_region_awaf_s7ux\",\n                \":@computed_region_6mkv_f3dw\",\n                \":@computed_region_vrxf_vc4k\",\n                \":@computed_region_bdys_3d7i\",\n                \":@computed_region_43wa_7qmu\",\n                \"second_approach\",\n                \"location_address\",\n                \"location_zip\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Point\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Calendar date\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"\",\n                \"An ID for the speed camera that may match other data sources.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"An internal-only unique ID for the speed camera. This ID will not match any other data source.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\"\n              ],\n            \"columns_format\" :\n              [\n                { \"view\" : \"coords\", \"align\" : \"left\" },\n                {},\n                {},\n                {},\n                {},\n                { \"align\" : \"left\", \"aggregate\" : \"count\" },\n                { \"noCommas\" : \"true\" },\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 11953,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2023-08-17T17:22:45.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"speed cameras\", \"traffic\", \"transportation\" ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Metadata_Frequency\", \"value\" : \"Updated daily\" },\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Department of Transportation\"\n                },\n                { \"key\" : \"Metadata_Time-Period\", \"value\" : \"Current\" }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.cityofchicago.org\",\n            \"license\" : \"See Terms of Use\"\n          },\n        \"permalink\" : \"https://data.cityofchicago.org/d/4i42-qv3h\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/Speed-Camera-Locations/4i42-qv3h\",\n        \"owner\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Chicago Traffic Tracker - Congestion Estimates by Regions\",\n            \"id\" : \"t2qc-9pjd\",\n            \"resource_name\" : \"t2qc-9pjd\",\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset contains the current estimated congestion for the 29 traffic regions. For a detailed description, please go to https://tas.chicago.gov, click the About button at the bottom of the page, and then the MAP LAYERS tab. \\n\\nThe Chicago Traffic Tracker estimates traffic congestion on Chicago’s arterial streets (non-freeway streets) in real-time by continuously monitoring and analyzing GPS traces received from Chicago Transit Authority (CTA) buses. Two types of congestion estimates are produced every 10 minutes: 1) by Traffic Segments and 2) by Traffic Regions or Zones. Congestion estimates by traffic segments gives observed speed typically for one-half mile of a street in one direction of traffic. Traffic Segment level congestion is available for about 300 miles of principal arterials. Congestion by Traffic Region gives the average traffic condition for all arterial street segments within a region. A traffic region is comprised of two or three community areas with comparable traffic patterns. 29 regions are created to cover the entire city (except O’Hare airport area). \\n\\nThere is much volatility in traffic segment speed. However, the congestion estimates for the traffic regions remain consistent for a relatively longer period. Most volatility in arterial speed comes from the very nature of the arterials themselves. Due to a myriad of factors, including but not limited to frequent intersections, traffic signals, transit movements, availability of alternative routes, crashes, short length of the segments, etc. Speed on individual arterial segments can fluctuate from heavily congested to no congestion and back in a few minutes. The segment speed and traffic region congestion estimates together may give a better understanding of the actual traffic conditions.\",\n            \"attribution\" : null,\n            \"attribution_link\" : null,\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T20:33:24.000Z\",\n            \"createdAt\" : \"2011-11-20T03:43:27.000Z\",\n            \"metadata_updated_at\" : \"2025-02-10T18:56:40.000Z\",\n            \"data_updated_at\" : \"2025-07-22T20:33:24.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 350,\n                \"page_views_last_month\" : 1531,\n                \"page_views_total\" : 71177,\n                \"page_views_last_week_log\" : 8.45532722030456,\n                \"page_views_last_month_log\" : 10.581200581924957,\n                \"page_views_total_log\" : 16.11914377529938\n              },\n            \"columns_name\" :\n              [\n                \" EAST\",\n                \" REGION_ID\",\n                \"REGION\",\n                \" WEST\",\n                \" CURRENT_SPEED\",\n                \" DESCRIPTION\",\n                \" SOUTH\",\n                \" NORTH\",\n                \" LAST_UPDATED\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"_east\",\n                \"_region_id\",\n                \"region\",\n                \"_west\",\n                \"current_speed\",\n                \"_description\",\n                \"_south\",\n                \"_north\",\n                \"_last_updt\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"Approximate longitude of the east edge of the region.\",\n                \"Unique arbitrary number to represent each region.\",\n                \"Name of the region.\",\n                \"Approximate longitude of the west edge of the region.\",\n                \"Estimated congestion level. Although expressed in miles per hour, this value is more a reflection of the congestion level in the region than it is indicative of the average raw speed vehicles are travelling within the region.\",\n                \"Description of the region.\",\n                \"Approximate latitude of the south edge of the region.\",\n                \"Approximate latitude of the north edge of the region.\",\n                \"Timestamp of the last update.\"\n              ],\n            \"columns_format\" :\n              [\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                { \"align\" : \"left\", \"aggregate\" : \"count\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"left\"\n                },\n                { \"align\" : \"left\" }\n              ],\n            \"download_count\" : 296980,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2014-09-12T20:08:47.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"sustainability\", \"traffic\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Frequency\",\n                  \"value\" : \"Data is updated every 15 minutes\"\n                },\n                { \"key\" : \"Metadata_Data-Owner\", \"value\" : \"Transportation\" },\n                {\n                  \"key\" : \"Metadata_Time-Period\",\n                  \"value\" : \"Real-time / reflects the last 10 minutes of traffic\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/t2qc-9pjd\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/Chicago-Traffic-Tracker-Congestion-Estimates-by-Re/t2qc-9pjd\",\n        \"owner\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Relocated Vehicles\",\n            \"id\" : \"5k2z-suxx\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset presents current and former locations of vehicles that have been relocated by the City of Chicago within the last 90 days. Vehicles may be relocated, but not impounded, due to inoperability, accident, severe weather, special events, construction or other work being performed in a thoroughfare where the vehicle was previously located.\",\n            \"attribution\" : \"City of Chicago\",\n            \"attribution_link\" : \"http://www.cityofchicago.org\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T17:16:30.000Z\",\n            \"createdAt\" : \"2011-09-30T08:00:22.000Z\",\n            \"metadata_updated_at\" : \"2020-09-02T15:14:28.000Z\",\n            \"data_updated_at\" : \"2025-07-22T17:16:30.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 67,\n                \"page_views_last_month\" : 236,\n                \"page_views_total\" : 46183,\n                \"page_views_last_week_log\" : 6.08746284125034,\n                \"page_views_last_month_log\" : 7.88874324889826,\n                \"page_views_total_log\" : 15.495105510007786\n              },\n            \"columns_name\" :\n              [\n                \"Relocated From Y Coordinate\",\n                \"Community Areas\",\n                \"Census Tracts\",\n                \"State\",\n                \"Relocated To Address Number\",\n                \"Plate\",\n                \"Relocated From Street Name\",\n                \"Zip Codes\",\n                \"Relocated From Suffix\",\n                \"Historical Wards 2003-2015\",\n                \"Relocated From Location (city)\",\n                \"Wards\",\n                \"Color\",\n                \"Relocated From Location\",\n                \"Relocated From Street Direction\",\n                \"Service Request Number\",\n                \"Relocated From Latitude\",\n                \"Relocated To Direction\",\n                \"Make\",\n                \"Relocated To Street Name\",\n                \"Relocated From Location (state)\",\n                \"Relocated From Location (zip)\",\n                \"Relocated To Suffix\",\n                \"Relocated From X Coordinate\",\n                \"Relocated Date\",\n                \"Relocated Reason\",\n                \"Boundaries - ZIP Codes\",\n                \"Relocated From Address Number\",\n                \"Relocated From Location (address)\",\n                \"Relocated From Longitude\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"relocated_from_y_coordinate\",\n                \":@computed_region_vrxf_vc4k\",\n                \":@computed_region_bdys_3d7i\",\n                \"state\",\n                \"relocated_to_address_number\",\n                \"plate\",\n                \"relocated_from_street_name\",\n                \":@computed_region_6mkv_f3dw\",\n                \"relocated_from_suffix\",\n                \":@computed_region_awaf_s7ux\",\n                \"relocated_from_location_city\",\n                \":@computed_region_43wa_7qmu\",\n                \"color\",\n                \"relocated_from_location\",\n                \"relocated_from_street_direction\",\n                \"service_request_number\",\n                \"relocated_from_latitude\",\n                \"relocated_to_direction\",\n                \"make\",\n                \"relocated_to_street_name\",\n                \"relocated_from_location_state\",\n                \"relocated_from_location_zip\",\n                \"relocated_to_suffix\",\n                \"relocated_from_x_coordinate\",\n                \"relocated_date\",\n                \"relocated_reason\",\n                \":@computed_region_rpca_8um6\",\n                \"relocated_from_address_number\",\n                \"relocated_from_location_address\",\n                \"relocated_from_longitude\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Point\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Calendar date\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Number\"\n              ],\n            \"columns_description\" :\n              [\n                \"The y coordinate of the location from which the vehicle was relocated, in State Plane Illinois East NAD 1983 projection.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"The location from which the vehicle was relocated in a special format that allows for mapping on this data portal.\",\n                \"\",\n                \"\",\n                \"The latitude of the location from which the vehicle was relocated.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"The x coordinate of the location from which the vehicle was relocated, in State Plane Illinois East NAD 1983 projection.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"The longitude of the location from which the vehicle was relocated\"\n              ],\n            \"columns_format\" :\n              [\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                {},\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                { \"view\" : \"coords\", \"align\" : \"left\" },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                {\n                  \"view\" : \"date_time\",\n                  \"align\" : \"left\",\n                  \"aggregate\" : \"count\"\n                },\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"right\"\n                },\n                {},\n                {}\n              ],\n            \"download_count\" : 13372,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2019-08-08T17:42:35.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"streets\", \"vehicles\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Frequency\",\n                  \"value\" : \"Data are updated multiple times per hour\"\n                },\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Streets & Sanitation\"\n                },\n                { \"key\" : \"Metadata_Time-Period\", \"value\" : \"Last 90 days\" }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.cityofchicago.org\",\n            \"license\" : \"See Terms of Use\"\n          },\n        \"permalink\" : \"https://data.cityofchicago.org/d/5k2z-suxx\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/Relocated-Vehicles/5k2z-suxx\",\n        \"owner\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"Chicago Traffic Tracker - Congestion Estimates by Segments\",\n            \"id\" : \"n4j6-wkkf\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset contains the current estimated speed for about 1250 segments covering 300 miles of arterial roads. For a more detailed description,  please go to https://tas.chicago.gov, click the About button at the bottom of the page, and then the MAP LAYERS tab.\\n\\nThe Chicago Traffic Tracker estimates traffic congestion on Chicago’s arterial streets (nonfreeway\\nstreets) in real-time by continuously monitoring and analyzing GPS traces received from Chicago Transit Authority (CTA) buses. Two types of congestion estimates are produced every ten minutes: 1) by Traffic Segments and 2) by Traffic Regions or Zones. Congestion estimate by traffic segments gives the observed speed typically for one-half mile of a street in one direction of traffic.\\n\\nTraffic Segment level congestion is available for about 300 miles of principal arterials. Congestion by Traffic Region gives the average traffic condition for all arterial street segments within a region. A traffic region is comprised of two or three community areas with comparable traffic patterns. 29 regions are created to cover the entire city (except O’Hare airport area).\\nThis dataset contains the current estimated speed for about 1250 segments covering 300 miles of arterial roads.\\nThere is much volatility in traffic segment speed. However, the congestion estimates for the traffic regions remain consistent for relatively longer period. Most volatility in arterial speed comes from the very nature of the arterials themselves. Due to a myriad of factors, including but not limited to frequent\\nintersections, traffic signals, transit movements, availability of alternative routes, crashes, short length of the segments, etc. speed on individual arterial segments can fluctuate from heavily congested to no congestion and back in a few minutes. The segment speed and traffic region congestion estimates\\ntogether may give a better understanding of the actual traffic conditions.\",\n            \"attribution\" : \"City of Chicago\",\n            \"attribution_link\" : \"http://www.chicagotraffictracker.com/\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-22T20:33:25.000Z\",\n            \"createdAt\" : \"2011-11-20T03:28:25.000Z\",\n            \"metadata_updated_at\" : \"2025-02-10T18:57:39.000Z\",\n            \"data_updated_at\" : \"2025-07-22T20:33:25.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 417,\n                \"page_views_last_month\" : 1689,\n                \"page_views_total\" : 79264,\n                \"page_views_last_week_log\" : 8.707359132080883,\n                \"page_views_last_month_log\" : 10.722807531169547,\n                \"page_views_total_log\" : 16.274396354270035\n              },\n            \"columns_name\" :\n              [\n                \"SEGMENTID\",\n                \"END_LONGITUDE\",\n                \" STREET_HEADING\",\n                \"DIRECTION\",\n                \"FROM_STREET\",\n                \"TO_STREET\",\n                \" CURRENT_SPEED\",\n                \" END_LATITUDE\",\n                \"START_LONGITUDE\",\n                \"LENGTH\",\n                \" START_LATITUDE\",\n                \"STREET\",\n                \" LAST_UPDATED\",\n                \" COMMENTS\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"segmentid\",\n                \"_lit_lon\",\n                \"_strheading\",\n                \"_direction\",\n                \"_fromst\",\n                \"_tost\",\n                \"_traffic\",\n                \"_lit_lat\",\n                \"start_lon\",\n                \"_length\",\n                \"_lif_lat\",\n                \"street\",\n                \"_last_updt\",\n                \"_comments\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"Unique arbitrary number to represent each segment.\",\n                \"\",\n                \"The position of the segment in the address grid. North, South, East, or West of State and Madison. \",\n                \"Traffic flow direction for the segment.\",\n                \"Start street for the segment in the direction of traffic flow.\",\n                \"End street for the segment in the direction of traffic flow.\",\n                \"A value of -1 means no estimate is available.\",\n                \"\",\n                \"The longitude associated with the starting point of the segment in the direction of traffic flow. For two-way streets it is roughly at the middle of the half that the segment is representing. For one-way streets this is the street center line. The startin\",\n                \"Length of the segment in miles.\",\n                \"\",\n                \"Street name of the traffic segment.\",\n                \"\",\n                \"\"\n              ],\n            \"columns_format\" :\n              [\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"displayStyle\" : \"plain\", \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\" },\n                {}\n              ],\n            \"download_count\" : 1827920,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2014-09-26T21:18:26.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"sustainability\", \"traffic\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Frequency\",\n                  \"value\" : \"Data is updated every 15 minutes\"\n                },\n                { \"key\" : \"Metadata_Data-Owner\", \"value\" : \"Transportation\" },\n                {\n                  \"key\" : \"Metadata_Time-Period\",\n                  \"value\" : \"Real-time / reflects the last 10 minutes of traffic\"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.cityofchicago.org\",\n            \"license\" : \"See Terms of Use\"\n          },\n        \"permalink\" : \"https://data.cityofchicago.org/d/n4j6-wkkf\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/Chicago-Traffic-Tracker-Congestion-Estimates-by-Se/n4j6-wkkf\",\n        \"owner\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"scy9-9wg4\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"cocadmin\"\n          }\n      }\n    ],\n  \"resultSetSize\" : 86,\n  \"timings\" : { \"serviceMillis\" : 41, \"searchMillis\" : [ 26, 6 ] },\n  \"warnings\" : []\n}"), 
    timing = c(redirect = 0, namelookup = 1.2e-05, connect = 0, 
    pretransfer = 6.9e-05, starttransfer = 0.095893, total = 0.0964
    ), cache = new.env(parent = emptyenv())), class = "httr2_response")
