% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourcoise_clear.R
\name{sourcoise_reset}
\alias{sourcoise_reset}
\title{Resets sourcoise}
\usage{
sourcoise_reset(root = NULL)
}
\arguments{
\item{root}{to force root (expert use)}
}
\value{
No return, effect is through removal of .sourcoise folders (this is a side effect, no undo possible)
}
\description{
Removes all \code{.sourcoise} folders found under the project root.
}
\examples{
\dontshow{if (rlang::is_installed("insee")) withAutoprint(\{ # examplesIf}
dir <- tempdir()
set_sourcoise_root(dir)
fs::file_copy(
   fs::path_package("sourcoise", "some_data.R"),
   dir,
   overwrite = TRUE)
data <- sourcoise("some_data.R", force_exec = TRUE)
sourcoise_reset()
\dontshow{\}) # examplesIf}
}
\seealso{
Other sourcoise: 
\code{\link{sourcoise}()},
\code{\link{sourcoise_clear}()},
\code{\link{sourcoise_clear_all}()},
\code{\link{sourcoise_refresh}()},
\code{\link{sourcoise_status}()}
}
\concept{sourcoise}
