\name{persp.pemt}
\Rdversion{1.1}
\alias{persp.pemt}

\title{Perspective Plots with Multi-directional Transiograms}

\description{The function draws perspective-plots the \eqn{2}{2}-D sections of a multi-directional transiogram computed without any ellipsoidal interpolation.}

\usage{\method{persp}{pemt}(x, main, mar, ask = TRUE, col = "white", ...)}

\arguments{
%%            x pemt object
%%         main title string
%%          mar vector to pass to par()  
%%          ask boolean to pass to par()
%%          col vector of colors
%%          ... other args to pass to persp()
  \item{x}{an object of the class \code{pemt}, typically with the output of the function \code{\link{pemt}}.}
  \item{main}{the main title (on top) whose font and size are fixed.}
  \item{mar}{a scalar or a numerical vector of the form \code{c(bottom, left, top, right)} which gives the number of margin lines to be specified on the four sides of image to plot. See \code{\link{par}}(\code{mar=}.).}
  \item{ask}{a logical value; if \code{TRUE}, the user is asked for input, before each plot. See \code{\link{par}}(\code{ask=}.).}
  \item{col}{a list of colors which is usually generated by \code{rev(\link{heat.colors}())}, or with other function for \code{\link{colors}}.}
  \item{\dots}{other arguments to pass to the function \code{\link{persp}}.}
}

\details{
A multidimensional transiogram is a diagram which shows the transition probabilities for a single pair of categories. The probability is computed for any lag vector \eqn{h}{h} through 
\deqn{\mbox{expm} (\Vert h \Vert R_h),}{expm(||h|| R),}
where entries of \eqn{R_h}{R} are not ellipsoidally interpolated, but they are estimated for the direction specified by the vector \eqn{h}{h}.

The exponential matrix is evaluated by the scaling and squaring algorithm.
}

\value{An image is produced on the current graphics device. No values are returned.}

\references{Carle, S. F., Fogg, G. E. (1997) Modelling Spatial Variability with One and Multidimensional Continuous-Lag Markov Chains. \emph{Mathematical Geology}, \bold{29}(7), 891-918.

Higham, N. J. (2008) \emph{Functions of Matrices: Theory and Computation}. Society for Industrial and Applied Mathematics.

Sartore, L. (2010) Geostatistical models for 3-D data. M.Phil. thesis, Ca' Foscari University of Venice.}


\author{Luca Sartore \email{drwolf85@gmail.com}}

\seealso{\code{\link{pemt}}, \code{\link{persp.multi_tpfit}}, \code{\link{persp}}, \code{\link{multi_tpfit}}, \code{\link{image.pemt}}, \code{\link{plot.transiogram}}}

\examples{\donttest{
data(ACM)

# Compute a 2-D section of a
# multi-directional transiogram
psEmpTr <- pemt(ACM$MAT3, ACM[, 1:3], 2,
                max.dist = c(200, 200, 20), 
                which.dire = c(1, 3))

# 3D-Plot for a 2-D sections of
# a multi-directional transiogram
persp(psEmpTr, col = rainbow(500), mar = .7,
      theta = 15, phi = 45)
}}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{spatial}
\keyword{distribution}
\keyword{hplot}
