% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporal_kde_sf.R
\name{bw_cv_likelihood_calc_tkde}
\alias{bw_cv_likelihood_calc_tkde}
\title{Bandwidth selection for Temporal Kernel density estimate by likelihood cross validation}
\usage{
bw_cv_likelihood_calc_tkde(events, w, bws, kernel_name)
}
\arguments{
\item{events}{A numeric vector representing the moments of occurrence of events}

\item{w}{The weight of the events}

\item{bws}{A numeric vector, the bandwidths to use}

\item{kernel_name}{The name of the kernel to use}
}
\value{
A vector with the cross validation scores (the higher the better).
}
\description{
Calculate the likelihood cross validation score for several bandwidths for the
Temporal Kernel density
}
\examples{
data(bike_accidents)
bike_accidents$Date <- as.POSIXct(bike_accidents$Date, format = "\%Y/\%m/\%d")
start <- min(bike_accidents$Date)
diff <- as.integer(difftime(bike_accidents$Date , start, units = "days"))
w <- rep(1,length(diff))
scores <- bw_cv_likelihood_calc_tkde(diff, w, seq(10,60,10), "quartic")
}
