% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_cor.R
\name{auto_cor}
\alias{auto_cor}
\title{Multicollinearity reduction via Pearson correlation}
\usage{
auto_cor(
  x = NULL,
  preference.order = NULL,
  cor.threshold = 0.5,
  verbose = TRUE
)
}
\arguments{
\item{x}{A data frame with predictors, or the result of \code{\link[=auto_vif]{auto_vif()}} Default: \code{NULL}.}

\item{preference.order}{Character vector indicating the user's order of preference to keep variables. Doesn't need to contain If not provided, variables in \code{x} are prioritised by their column order. Default: \code{NULL}.}

\item{cor.threshold}{Numeric between 0 and 1, with recommended values between 0.5 and 0.9. Maximum Pearson correlation between any pair of the selected variables. Default: \code{0.50}}

\item{verbose}{Logical. if \code{TRUE}, describes the function operations to the user. Default:: \code{TRUE}}
}
\value{
List with three slots:
\itemize{
\item \code{cor}: correlation matrix of the selected variables.
\item \code{selected.variables}: character vector with the names of the selected variables.
\item \code{selected.variables.df}: data frame with the selected variables.
}
}
\description{
Computes the correlation matrix among a set of predictors, orders the correlation matrix according to a user-defined preference order, and removes variables one by one, taking into account the preference order, until the remaining ones are below a given Pearson correlation threshold. \strong{Warning}: variables in \code{preference.order} not in \code{colnames(x)}, and non-numeric columns are removed silently from \code{x} and \code{preference.order}. The same happens with rows having NA values (\code{\link[=na.omit]{na.omit()}} is applied). The function issues a warning if zero-variance columns are found.
}
\details{
Can be chained together with \code{\link[=auto_vif]{auto_vif()}} through pipes, see the examples below.
}
\examples{
if(interactive()){

 #load data
 data(plant_richness_df)

 #on a data frame
 out <- auto_cor(x = plant_richness_df[, 5:21])

 #getting the correlation matrix
 out$cor

 #getting the names of the selected variables
 out$selected.variables

 #getting the data frame of selected variables
 out$selected.variables.df

 #on the result of auto_vif
 out <- auto_vif(x = plant_richness_df[, 5:21])
 out <- auto_cor(x = out)

 #with pipes
 out <- plant_richness_df[, 5:21] \%>\%
 auto_vif() \%>\%
 auto_cor()

}
}
\seealso{
\code{\link[=auto_vif]{auto_vif()}}
}
