% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliermethods.R
\name{adjustboxplots}
\alias{adjustboxplots}
\title{Adjust the boxplots bounding fences using medcouple to flag suspicious outliers.}
\usage{
adjustboxplots(
  data,
  var,
  output = "outlier",
  a = -4,
  b = 3,
  coef = 1.5,
  pc = FALSE,
  pcvar = NULL,
  boot = FALSE
)
}
\arguments{
\item{data}{\code{dataframe}. Dataframe to check for outliers.}

\item{var}{\code{string}. Environmental predictor considered in flagging suspicious outliers.}

\item{output}{\code{string} Either clean: for dataframe with no suspicious outliers or
outlier: to return dataframe with only outliers.}

\item{a}{\code{numeric}. Constant for adjusted boxplots.}

\item{b}{\code{numeric}. Constant for adjusted boxplots.}

\item{coef}{\code{numeric}. Constant for adjusted boxplots.}

\item{pc}{Whether principal component analysis will be computed. Default \code{FALSE}}

\item{pcvar}{Principal component analysis to e used for outlier detection after PCA. Default \code{PC1}}

\item{boot}{Whether bootstrapping will be computed. Default \code{FALSE}}
}
\value{
\code{dataframe}. Dataframe with or with no outliers.
}
\description{
Adjust the boxplots bounding fences using medcouple to flag suspicious outliers.
}
\examples{
\donttest{
data("efidata")

danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package='specleanr'))

refdata <- pred_extract(data = efidata, raster= wcd ,
                      lat = 'decimalLatitude', lon= 'decimalLongitude',
                       colsp = "scientificName",
                       bbox = db,
                       minpts = 10)

adout <- adjustboxplots(data = refdata[["Thymallus thymallus"]], var = 'bio6', output='outlier')

}
}
\references{
Hubert M, Vandervieren E. 2008. An adjusted boxplot for skewed distributions.
Computational Statistics and Data Analysis 52:5186-5201.
}
