% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliermethods.R
\name{distboxplot}
\alias{distboxplot}
\title{Distribution boxplot}
\usage{
distboxplot(
  data,
  var,
  output,
  p1 = 0.025,
  p2 = 0.975,
  boot = FALSE,
  pc = FALSE,
  pcvar = NULL
)
}
\arguments{
\item{data}{Dataframe or vector where to check outliers.}

\item{var}{Variable to be used for outlier detection if \strong{data} is not a vector file.}

\item{output}{Either \strong{clean}: for clean data output without outliers; \strong{outliers}:
for outlier data frame or vectors.}

\item{p1, p2}{Different pvalues for outlier detection \code{Schwertman et al. 2004)}.}

\item{boot}{Whether bootstrapping will be computed. Default \code{FALSE}}

\item{pc}{Whether principal component analysis will be computed. Default \code{FALSE}}

\item{pcvar}{Principal component analysis to e used for outlier detection after PCA. Default \code{PC1}}
}
\value{
Either clean or outliers.
}
\description{
Distribution boxplot
}
\examples{

\donttest{
data("efidata")

danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package='specleanr'))

refdata <- pred_extract(data = efidata, raster= wcd ,
                          lat = 'decimalLatitude', lon= 'decimalLongitude',
                          colsp = "scientificName",
                          bbox = db,
                          minpts = 10)

 bxout <- distboxplot(data = refdata[["Thymallus thymallus"]], var = 'bio6', output='outlier')
}

}
