% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractoutliers.R
\name{extractoutliers}
\alias{extractoutliers}
\title{Extract outliers for a one species}
\usage{
extractoutliers(x, sp = NULL)
}
\arguments{
\item{x}{\code{list}. Outlier outputs for both single and multiple species.}

\item{sp}{\code{string}. Species name or index in the list from datacleaner output. NULL for a single species}
}
\value{
\code{data frame} Outliers for each method
}
\description{
Extract outliers for a one species
}
\examples{

\donttest{

data(efidata)

danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package = "specleanr"))


extdf <- pred_extract(data = efidata, raster = wcd,
                     lat = 'decimalLatitude', lon = 'decimalLongitude',
                     colsp = 'scientificName',
                     list = TRUE,verbose = FALSE,
                   minpts = 6,merge = FALSE)

#outlier detection

outliersdf <- multidetect(data = extdf, output='outlier', var = 'bio6',
                         exclude = c('x','y'), multiple = TRUE,
                         methods = c('mixediqr', "iqr", "iqr", "logboxplot"),
                         silence_true_errors = FALSE,
                        verbose = FALSE, sdm = TRUE)

extoutlier <- extractoutliers(x=outliersdf, sp = 3)
}


}
