% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwconncomp.R
\name{bwconncomp}
\alias{bwconncomp}
\title{Label Connected Clusters of Certain Size}
\usage{
bwconncomp(infile, outfile = NULL, retimg = TRUE, conn = 26,
  reorient = FALSE, spmdir = spm_dir(), verbose = TRUE)
}
\arguments{
\item{infile}{input filename}

\item{outfile}{output filename}

\item{retimg}{Return the image instead of matlab output}

\item{conn}{Connections to be passed to MATLAB's \code{bwconncomp}}

\item{reorient}{If \code{retimg}, then this argument is passed to
\code{readNIfTI}}

\item{spmdir}{(character) path for SPM12.  If NULL, assumes
SPM12 is in matlabpath.}

\item{verbose}{Print Diagnostics}
}
\value{
Name of output file or \code{nifti} object,
depending on \code{retimg}
}
\description{
Get Cluster of certain size from spm_bwlabel
}
\examples{
library(neurobase)
set.seed(1234)
dims = c(30, 30, 10)
arr = array(rnorm(prod(dims)), dim = dims)
nim = nifti(arr)
mask = datatyper(nim > 1)
\dontrun{
cc = bwconncomp(mask)
tab = table(c(cc))
}
}

