% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCAloc_methods.R
\name{plot.PCAloc}
\alias{plot.PCAloc}
\title{Plotting method PCAloc object}
\usage{
\method{plot}{PCAloc}(
  x,
  type = c("loadings", "screeplot", "scores", "score_distances", "biplot"),
  ...
)
}
\arguments{
\item{x}{object of class PCAloc}

\item{type}{character indicating the type of plot, see details.}

\item{...}{further arguments passed down.}
}
\value{
Returns plots in ggplot2.
}
\description{
Plotting method PCAloc object
}
\examples{
\donttest{
# set seed
set.seed(236)

# create data and setup
data = matrix(rnorm(2000), ncol = 4)
groups = sample(1:10, 500, replace = TRUE)
W = time_weights(N = 10, c(3,2,1))

# calculate covariances
covs = ssMRCD(data, groups = groups, weights = W, lambda = 0.3)

# calculate sparse PCA
pca = sparsePCAloc(eta = 0.3, gamma = 0.7, cor = FALSE, COVS = covs$MRCDcov,
             n_max = 1000, increase_rho = list(TRUE, 50, 1), trace = FALSE)

# align loadings
pca$PC = align_PC(PC = pca$PC, N = pca$N, p = pca$p, type = "mean")

# plot different PCA plots
plot(x = pca, type = "score_distances", groups = groups, X = data, ssMRCD = covs, k = 2)
plot(x = pca, type = "biplot", color = "variable")
plot(x = pca, type = "scores", groups = groups, X = data, ssMRCD = covs, k = 1)
plot(x = pca, type = "screeplot")
plot(x = pca, type = "loadings", k = 1)
}
}
