% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_design.R
\name{generate_design}
\alias{generate_design}
\title{Generate the design of a mouse-tracking experiment}
\usage{
generate_design(I = 10, J = 12, K = c(4), Z.type = c("symmetric"))
}
\arguments{
\item{I}{(integer) number of individuals}

\item{J}{(integer) number of trials}

\item{K}{(list of integers) list of length Q of the number of levels for each categorical variable}

\item{Z.type}{(list of characters) list of length Q of the methods (symmetric or random) to generate the matrix (see \code{\link{generate_Z}})}
}
\value{
a dataframe of the order (sbj,trial,variable1,...variableQ)
}
\description{
Generate the design of a mouse-tracking experiment
}
\details{
The function generates a dataframe containing the experimental design of a mouse-tracking study. The design is of the order (sbj,trial,variable1,...variableQ), where variable1,...,variableQ are Q categorical variables each with K_1,...,K_Q levels. The levels are codified using hundreds.
This is an internal function, generally not to be called by the user.
}
\examples{

## Generate a design with Q = 2 categorical variables:
## the first variable has K = 4 levels generated via symmetric method
## the second variable has K = 3 levels generated via random method.
X <- generate_design(I = 10, J = 12, K = c(4,3), Z.type = c("symmetric","random"))
print(X)
}
