% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterFactuals.R
\name{get_y_t}
\alias{get_y_t}
\title{Compute the observation \eqn{y_t=\mu_{y,t} + B_{y,t}e_t} for a single time period}
\usage{
get_y_t(mu_yt, B_yt, e_t)
}
\arguments{
\item{mu_yt}{a \eqn{(d \times 1)} vector of the conditional mean for the time period \eqn{t}.}

\item{B_yt}{a \eqn{(d \times d)} impact matrix for the time period \eqn{t}.}

\item{e_t}{a \eqn{(d \times 1)} vector of the structural shocks for the time period \eqn{t}.}
}
\value{
Returns the \eqn{(d \times 1)} vector of observations for the time period \eqn{t}.
}
\description{
\code{get_y_t} computes the observation \eqn{y_t=\mu_{y,t} + B_{y,t}e_t} for a single time period
 based on the conditional mean, impact matrix, and shock vector.
}
\details{
This is used in simulation of the counterfactual scenarios.
}
\keyword{internal}
