% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSTA.R
\name{plot.STA}
\alias{plot.STA}
\title{Plot function for class STA}
\usage{
\method{plot}{STA}(
  x,
  ...,
  trials = NULL,
  traits = NULL,
  what = NULL,
  plotType = c("base", "spatial"),
  spaTrend = c("raw", "percentage"),
  outCols = ifelse(plotType == "base", 2, 3),
  title = NULL,
  output = TRUE
)
}
\arguments{
\item{x}{An object of class STA.}

\item{...}{Further graphical parameters.}

\item{trials}{A character vector indicating the trials to plot. If
\code{trials = NULL}, all trials are plotted.}

\item{traits}{A character vector indicating the traits to plot. If
\code{traits = NULL}, all traits are plotted.}

\item{what}{A character string indicating whether the fitted model with
genotype as fixed (\code{what = "fixed"}) or genotype as random
(\code{what = "random"}) factor should be plotted.
If \code{x} contains only one model this model is chosen automatically.}

\item{plotType}{A character string indicating whether \code{base} plots or
\code{spatial} plots should be made.}

\item{spaTrend}{A character string indicating how the spatial trend should
be displayed. Either "raw" (original scale), or "percentage". If
"percentage", the estimated spatial trend is scaled (i.e., divided by the
average of the observed response variable of interest across the field) and
results are shown as a percentage.}

\item{outCols}{An integer indicating the number of columns to use for
displaying the plots. Usually the default of 2 for base plots and 3 for
spatial plots will be fine, but decreasing the numbers may help for nicer
printing.}

\item{title}{A character string used a title for the plot. Note that when
a title is specified and multiple plots are created, all plots will get the
same title.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a list of ggplot objects is invisibly returned.}
}
\value{
A list containing ggplot objects for the selected plots.
}
\description{
This function draws either four base plots:
\itemize{
\item{A histogram of the residuals}
\item{A normal Q-Q plot}
\item{A residuals vs fitted values plot}
\item{An absolute residuals vs fitted values plot}
}
or five or six spatial plots:
\itemize{
\item{A spatial plot of the raw data}
\item{A spatial plot of the fitted data}
\item{A spatial plot of the residuals}
\item{A spatial plot of the estimated spatial trend (SpATS only)}
\item{A spatial plot of the BLUEs or BLUPs}
\item{A histogram of the BLUEs or BLUPs}
}
Spatial plots can only be made if the data contains both row and column
information.
}
\examples{
## Run a single trait analysis using SpATS.
modSp <- fitTD(TD = TDHeat05,
               design = "res.rowcol",
               traits = "yield")

## Create base plots.
plot(modSp,
     what = "fixed",
     plotType = "base")

## Create spatial plots.
plot(modSp,
     what = "fixed",
     plotType = "spatial")

## Create spatial plots showing the spatial trend as percentage.
plot(modSp,
     what = "fixed",
     plotType = "spatial",
     spaTrend = "percentage")

}
\seealso{
Other functions for STA objects: 
\code{\link{STAtoCross}()},
\code{\link{STAtoTD}()},
\code{\link{report.STA}()},
\code{\link{summary.STA}()}
}
\concept{functions for STA objects}
