% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.gen}
\alias{size.ci.gen}
\title{Sample size for a confidence interval for any type of parameter}
\usage{
size.ci.gen(alpha, se, n0, w)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{se}{standard error of parameter estimate from prior/pilot study}

\item{n0}{sample size of prior/pilot study}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a single population parameter
with desired precision using a standard error for the parameter estimate
from a prior or pilot study. This function can be used with any type of
parameter where the standard error of the parameter estimate is a function
of the square root of the sample size (most parameter estimates have this
property). This function also assumes that the sampling distribution of the
parameter estimate is approximately normal in large samples.
}
\examples{
size.ci.gen(.05, 2.89, 30, 8)

# Should return:
# Sample size
#          61
 

}
