% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_results.R
\name{get_cantonalvotes}
\alias{get_cantonalvotes}
\title{Get national results and counting status in real time or for selected dates or a time range in the past}
\usage{
get_cantonalvotes(geolevel = "municipality", votedates = NULL,
  from_date = NULL, to_date = NULL)
}
\arguments{
\item{geolevel}{geographical level for which the results should be loaded.  options: "canton", "district","municipality" or "zh_counting_districts"}

\item{votedates}{dates of the ballots to be selected. Default: most recent ballot available. Format = "YYYY-MM-DD"}

\item{from_date}{starting point in time from which vote-results should be retrived. Format = "YYYY-MM-DD"}

\item{to_date}{end point in time to which vote-results should be retrived. Format = "YYYY-MM-DD"}
}
\value{
a tibble containing the results
}
\description{
\code{get_cantonalsvotes} is one of the two main functions of swissvote package. It allows to retrieve the results and the counting status for national ballots.
}
\details{
get_cantonalvotes - retrieve vote results for cantonal ballots at district- or municipality level for selected dates or a given date range.
}
\examples{
# select by range
results <- get_cantonalvotes(geolevel="district",from_date = "2019-01-01",to_date="2019-12-31")

# select specific votedate(s)
 
 get_cantonalvotes(votedates="2019-02-10")


# get the results at counting district level
# yields the same result as the municipality level, with the 
# exception of Winterthur and Zurich,
# where detailed counting district results are returned instead.

get_cantonalvotes(votedate="2019-09-22",geolevel = "zh_counting_districts")




}
